/**
 * @file Bts2App_Config.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief BtStackIf to Application messages for function block BTS_FB_CONFIG.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_CONFIG.
 */

#ifndef _BTS_2_APP_CONFIG_MSG_H_
#define _BTS_2_APP_CONFIG_MSG_H_

#include "Bts2App_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class Bts2App_SetDummyResult : public Bts2App_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   Bts2App_SetDummyResult();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   Bts2App_SetDummyResult(IN const Bts2App_SetDummyResult& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   Bts2App_SetDummyResult& operator=(IN const Bts2App_SetDummyResult& ref);

   /**
    * Destructor.
    */
   virtual ~Bts2App_SetDummyResult();

   /**
    * Trace function for output parameters.
    */
   virtual void doOutputTrace(void);

   /**
    * Trigger callback message.
    *
    * @param[in] callback: callback reference
    */
   virtual void triggerCallback(IN BtStackIfCallback& callback);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual Bts2App_BaseMessage* clone(void) const;

   inline void setRequestResult(IN const BTSRequestResult result) { _result = result; }
   inline void setRemoteDeviceAddress(IN const BTSBDAddress& remoteDeviceAddress) { _remoteDeviceAddress = remoteDeviceAddress; }

   inline BTSRequestResult getRequestResult(void) const { return _result; }
   inline void getRemoteDeviceAddress(OUT BTSBDAddress& remoteDeviceAddress) const { remoteDeviceAddress = _remoteDeviceAddress; }
   inline const BTSBDAddress& getRemoteDeviceAddress(void) const { return _remoteDeviceAddress; }
   inline BTSBDAddress& getRemoteDeviceAddressMutable(void) { return _remoteDeviceAddress; }

private:
   BTSRequestResult _result; /**< parameter result */
   // see base class: BTSBDAddress _deviceAddress;
   BTSBDAddress _remoteDeviceAddress; /**< parameter remote device address */
};

} //btstackif

#endif //_BTS_2_APP_CONFIG_MSG_H_
