/**
 * @file TrcApp2Bts.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Traces for App2Bts messages.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of traces for App2Bts messages.
 */

#include "App2Bts_MessageWrapper.h"
#include "TraceClasses.h"
#include "FwTrace.h"
#include "BtsUtils.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BTS_APP2BTS
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/TrcApp2Bts.cpp.trc.h"
#else
#include "BtStackIfTypesTrace.h"
#include "BtStackInternalTypesTrace.h"
#include "BtStackInternalOpcodesTrace.h"
#endif
#endif

namespace btstackif {

void App2Bts_SetDummy::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   // TODO: second deviceAddress;
   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   // TODO: second deviceAddress;
   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_StartInternalCommunication::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_TriggerFbConnectionInitialized::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SwitchBluetoothOnOff::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u bluetoothMode=%d adapterMode=%d",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            ETG_ENUM(TRC_BTSBluetoothMode, _bluetoothMode),
            ETG_ENUM(TRC_BTSAdapterMode, _adapterMode)));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u bluetoothMode=%s adapterMode=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            getBluetoothMode2String(_bluetoothMode),
            getAdapterMode2String(_adapterMode)));

#endif
}

void App2Bts_GetBluetoothOnOffStatus::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SwitchBluetoothHardwareOnOff::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u bluetoothMode=%d",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            ETG_ENUM(TRC_BTSBluetoothMode, _bluetoothMode)));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u bluetoothMode=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            getBluetoothMode2String(_bluetoothMode)));

#endif
}

void App2Bts_SetLocalBtName::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u adapterName=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            _adapterName.c_str()));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u adapterName=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            _adapterName.c_str()));

#endif
}

void App2Bts_GetLocalBtName::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SetDeviceIdServiceRecord::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u specificationID=0x%04X vendorID=0x%04X productID=0x%04X version=0x%04X primaryRecord=%d vendorIDSource=0x%04X clientExecutableURL=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            _serviceRecord.specificationID,
            _serviceRecord.vendorID,
            _serviceRecord.productID,
            _serviceRecord.version,
            ETG_ENUM(TRC_BTSBool, _serviceRecord.primaryRecord),
            _serviceRecord.vendorIDSource,
            _serviceRecord.clientExecutableURL.c_str()));
   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): serviceDescription=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _serviceRecord.serviceDescription.c_str()));
   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): clientDocumentationURL=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _serviceRecord.clientDocumentationURL.c_str()));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u specificationID=0x%04X vendorID=0x%04X productID=0x%04X version=0x%04X primaryRecord=%s vendorIDSource=0x%04X clientExecutableURL=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            _serviceRecord.specificationID,
            _serviceRecord.vendorID,
            _serviceRecord.productID,
            _serviceRecord.version,
            getBool2String(_serviceRecord.primaryRecord),
            _serviceRecord.vendorIDSource,
            _serviceRecord.clientExecutableURL.c_str()));
   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): serviceDescription=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _serviceRecord.serviceDescription.c_str()));
   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): clientDocumentationURL=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _serviceRecord.clientDocumentationURL.c_str()));

#endif
}

void App2Bts_SetDeviceForRestrictedPairingConnecting::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress, true);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress, true);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_SetLocalAdapterModes::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u discoverableMode=%d discoverableTimeout=%u connectableMode=%d connectableTimeout=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            ETG_ENUM(TRC_BTSLocalMode, _discoverableMode),
            _discoverableTimeout,
            ETG_ENUM(TRC_BTSLocalMode, _connectableMode),
            _connectableTimeout));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u discoverableMode=%s discoverableTimeout=%u connectableMode=%s connectableTimeout=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            getLocalMode2String(_discoverableMode),
            _discoverableTimeout,
            getLocalMode2String(_connectableMode),
            _connectableTimeout));

#endif
}

void App2Bts_GetLocalAdapterModes::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_StartDiscovery::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_StopDiscovery::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_GetDiscoveringStatus::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_StartPairing::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_CancelPairing::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_SetPinCode::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X pinCode=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            _pinCode.c_str()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X pinCode=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            _pinCode.c_str()));

#endif
}

void App2Bts_ConfirmSecureSimplePairing::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X sspMode=%d confirmationMode=%d numericValue=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSSspMode, _sspMode),
            ETG_ENUM(TRC_BTSConfirmationMode, _confirmationMode),
            _numericValue.c_str()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X sspMode=%s confirmationMode=%s numericValue=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getSspMode2String(_sspMode),
            getConfirmationMode2String(_confirmationMode),
            _numericValue.c_str()));

#endif
}

void App2Bts_SetLinkKey::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X linkKeyType=%d linkKey=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSLinkKeyType, _linkKeyType),
            _linkKey.c_str() /*DONE: format*/));
   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): dLinkKey=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _dLinkKey.c_str() /*DONE: format*/));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X linkKeyType=%s linkKey=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getLinkKeyType2String(_linkKeyType),
            _linkKey.c_str() /*DONE: format*/));
   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): dLinkKey=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _dLinkKey.c_str() /*DONE: format*/));

#endif
}

void App2Bts_ConnectProtocol::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X protocolId=%d sppUuid=%32s masInstance=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSProtocolId, _protocolId),
            _sppUuid.c_str() /*DONE: format*/,
            _masInstance.c_str() /*DONE: format*/));
   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): pageTimeout=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _pageTimeout));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X protocolId=%s sppUuid=%32s masInstance=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getProtocolId2String(_protocolId),
            _sppUuid.c_str() /*DONE: format*/,
            _masInstance.c_str() /*DONE: format*/));
   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): pageTimeout=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _pageTimeout));

#endif
}

void App2Bts_AcceptRemoteProtocolConnect::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X protocolId=%d sppUuid=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSProtocolId, _protocolId),
            _sppUuid.c_str()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X protocolId=%s sppUuid=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getProtocolId2String(_protocolId),
            _sppUuid.c_str()));

#endif
}

void App2Bts_RejectRemoteProtocolConnect::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X protocolId=%d sppUuid=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSProtocolId, _protocolId),
            _sppUuid.c_str()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X protocolId=%s sppUuid=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getProtocolId2String(_protocolId),
            _sppUuid.c_str()));

#endif
}

void App2Bts_DisconnectProtocol::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X protocolId=%d sppUuid=%32s masInstance=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSProtocolId, _protocolId),
            _sppUuid.c_str() /*DONE: format*/,
            _masInstance.c_str() /*DONE: format*/));
   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): pauseBtStreaming=%d",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            ETG_ENUM(TRC_BTSBool, _pauseBtStreaming)));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X protocolId=%s sppUuid=%32s masInstance=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getProtocolId2String(_protocolId),
            _sppUuid.c_str() /*DONE: format*/,
            _masInstance.c_str() /*DONE: format*/));
   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): pauseBtStreaming=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            getBool2String(_pauseBtStreaming)));

#endif
}

void App2Bts_DisconnectDevice::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X pauseBtStreaming=%d",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSBool, _pauseBtStreaming)));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X pauseBtStreaming=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getBool2String(_pauseBtStreaming)));

#endif
}

void App2Bts_GetProtocolConnectionStatus::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X protocolId=%d sppUuid=%32s masInstance=%s",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSProtocolId, _protocolId),
            _sppUuid.c_str() /*DONE: format*/,
            _masInstance.c_str() /*DONE: format*/));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X protocolId=%s sppUuid=%32s masInstance=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getProtocolId2String(_protocolId),
            _sppUuid.c_str() /*DONE: format*/,
            _masInstance.c_str() /*DONE: format*/));

#endif
}

void App2Bts_GetDeviceConnectionStatus::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_StartRemoteServiceSearch::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X searchType=%d rejectIfNotConnected=%d",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSSearchType, _searchType),
            ETG_ENUM(TRC_BTSBool, _rejectIfNotConnected)));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X searchType=%s rejectIfNotConnected=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getSearchType2String(_searchType),
            getBool2String(_rejectIfNotConnected)));

#endif
}

void App2Bts_CancelRemoteServiceSearch::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X searchType=%d",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            ETG_ENUM(TRC_BTSSearchType, _searchType)));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X searchType=%s",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower(),
            getSearchType2String(_searchType)));

#endif
}

void App2Bts_QueryRemoteName::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_RequestLinkQuality::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_StartTestMode::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   BTSBDAddressTrace traceAddr(_deviceAddress);

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#else

   BTSBDAddressTrace traceAddr(_deviceAddress);

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u btAddr=%08X%04X",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle,
            traceAddr.getUpper(), traceAddr.getLower()));

#endif
}

void App2Bts_StopTestMode::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_RequestTestModeLinkQuality::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SetTelephonyDummy::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SetPhonebookDummy::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SetMessagingDummy::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SetMediaPlayerDummy::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SetWblDummy::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_TriggerFbWblInitialized::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_AllowWblCommunication::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_BlockWblCommunication::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_GetWblCommunicationStatus::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_GetWblServiceAvailability::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_GetWblLastIntendedMode::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_GetWblSupportedRestrictions::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_GetWblWiFiSetupStatus::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_GetWblHealthinessIndicator::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

void App2Bts_SetEcnrDummy::doInputTrace(void)
{
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE

   ETG_TRACE_USR1((" App2Bts: 0x%08X (%d): SH=%u",
            getMessageTraceId(),
            ETG_ENUM(TRC_BTSApp2BtsOpcode, _opCode),
            _sessionHandle));

#else

   BTS_TRACE_USR1((" App2Bts: 0x%08X (%s): SH=%u",
            getMessageTraceId(),
            getApp2BtsOpcode2String(_opCode),
            _sessionHandle));

#endif
}

} //btstackif
