/**
 * @file App2Bts_Telephony.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_TELEPHONY.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_TELEPHONY.
 */

#include "App2Bts_Telephony.h"

namespace btstackif {

App2Bts_SetTelephonyDummy::App2Bts_SetTelephonyDummy()
: App2Bts_BaseMessage(BTS_FB_TELEPHONY, App2BtsOC_SetTelephonyDummy)
{
}

App2Bts_SetTelephonyDummy::App2Bts_SetTelephonyDummy(IN const App2Bts_SetTelephonyDummy& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_SetTelephonyDummy& App2Bts_SetTelephonyDummy::operator=(IN const App2Bts_SetTelephonyDummy& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_SetTelephonyDummy::~App2Bts_SetTelephonyDummy()
{
}

App2Bts_BaseMessage* App2Bts_SetTelephonyDummy::clone(void) const
{
   return new App2Bts_SetTelephonyDummy(*this);
}

} //btstackif
