/**
 * @file App2Bts_Connection.cpp
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Implementation of messages for function block BTS_FB_CONNECTION.
 */

#include "App2Bts_Connection.h"

namespace btstackif {

App2Bts_StartInternalCommunication::App2Bts_StartInternalCommunication()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_StartInternalCommunication)
{
}

App2Bts_StartInternalCommunication::App2Bts_StartInternalCommunication(IN const App2Bts_StartInternalCommunication& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_StartInternalCommunication& App2Bts_StartInternalCommunication::operator=(IN const App2Bts_StartInternalCommunication& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_StartInternalCommunication::~App2Bts_StartInternalCommunication()
{
}

App2Bts_BaseMessage* App2Bts_StartInternalCommunication::clone(void) const
{
   return new App2Bts_StartInternalCommunication(*this);
}

App2Bts_TriggerFbConnectionInitialized::App2Bts_TriggerFbConnectionInitialized()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_TriggerFbConnectionInitialized)
{
}

App2Bts_TriggerFbConnectionInitialized::App2Bts_TriggerFbConnectionInitialized(IN const App2Bts_TriggerFbConnectionInitialized& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_TriggerFbConnectionInitialized& App2Bts_TriggerFbConnectionInitialized::operator=(IN const App2Bts_TriggerFbConnectionInitialized& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_TriggerFbConnectionInitialized::~App2Bts_TriggerFbConnectionInitialized()
{
}

App2Bts_BaseMessage* App2Bts_TriggerFbConnectionInitialized::clone(void) const
{
   return new App2Bts_TriggerFbConnectionInitialized(*this);
}

App2Bts_SwitchBluetoothOnOff::App2Bts_SwitchBluetoothOnOff()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SwitchBluetoothOnOff)
{
   _bluetoothMode = BTS_BT_MODE_LAST;
   _adapterMode = BTS_ADAPTER_MODE_LAST;
}

App2Bts_SwitchBluetoothOnOff::App2Bts_SwitchBluetoothOnOff(IN const App2Bts_SwitchBluetoothOnOff& ref)
: App2Bts_BaseMessage(ref)
{
   _bluetoothMode = ref._bluetoothMode;
   _adapterMode = ref._adapterMode;
}

App2Bts_SwitchBluetoothOnOff& App2Bts_SwitchBluetoothOnOff::operator=(IN const App2Bts_SwitchBluetoothOnOff& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _bluetoothMode = ref._bluetoothMode;
   _adapterMode = ref._adapterMode;

   return *this;
}

App2Bts_SwitchBluetoothOnOff::~App2Bts_SwitchBluetoothOnOff()
{
}

App2Bts_BaseMessage* App2Bts_SwitchBluetoothOnOff::clone(void) const
{
   return new App2Bts_SwitchBluetoothOnOff(*this);
}

App2Bts_GetBluetoothOnOffStatus::App2Bts_GetBluetoothOnOffStatus()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_GetBluetoothOnOffStatus)
{
}

App2Bts_GetBluetoothOnOffStatus::App2Bts_GetBluetoothOnOffStatus(IN const App2Bts_GetBluetoothOnOffStatus& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetBluetoothOnOffStatus& App2Bts_GetBluetoothOnOffStatus::operator=(IN const App2Bts_GetBluetoothOnOffStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetBluetoothOnOffStatus::~App2Bts_GetBluetoothOnOffStatus()
{
}

App2Bts_BaseMessage* App2Bts_GetBluetoothOnOffStatus::clone(void) const
{
   return new App2Bts_GetBluetoothOnOffStatus(*this);
}

App2Bts_SwitchBluetoothHardwareOnOff::App2Bts_SwitchBluetoothHardwareOnOff()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SwitchBluetoothHardwareOnOff)
{
   _bluetoothMode = BTS_BT_MODE_LAST;
}

App2Bts_SwitchBluetoothHardwareOnOff::App2Bts_SwitchBluetoothHardwareOnOff(IN const App2Bts_SwitchBluetoothHardwareOnOff& ref)
: App2Bts_BaseMessage(ref)
{
   _bluetoothMode = ref._bluetoothMode;
}

App2Bts_SwitchBluetoothHardwareOnOff& App2Bts_SwitchBluetoothHardwareOnOff::operator=(IN const App2Bts_SwitchBluetoothHardwareOnOff& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _bluetoothMode = ref._bluetoothMode;

   return *this;
}

App2Bts_SwitchBluetoothHardwareOnOff::~App2Bts_SwitchBluetoothHardwareOnOff()
{
}

App2Bts_BaseMessage* App2Bts_SwitchBluetoothHardwareOnOff::clone(void) const
{
   return new App2Bts_SwitchBluetoothHardwareOnOff(*this);
}

App2Bts_SetLocalBtName::App2Bts_SetLocalBtName()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SetLocalBtName)
{
   // _adapterName: init is done by member constructor
}

App2Bts_SetLocalBtName::App2Bts_SetLocalBtName(IN const App2Bts_SetLocalBtName& ref)
: App2Bts_BaseMessage(ref)
{
   _adapterName = ref._adapterName;
}

App2Bts_SetLocalBtName& App2Bts_SetLocalBtName::operator=(IN const App2Bts_SetLocalBtName& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _adapterName = ref._adapterName;

   return *this;
}

App2Bts_SetLocalBtName::~App2Bts_SetLocalBtName()
{
}

App2Bts_BaseMessage* App2Bts_SetLocalBtName::clone(void) const
{
   return new App2Bts_SetLocalBtName(*this);
}

App2Bts_GetLocalBtName::App2Bts_GetLocalBtName()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_GetLocalBtName)
{
}

App2Bts_GetLocalBtName::App2Bts_GetLocalBtName(IN const App2Bts_GetLocalBtName& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetLocalBtName& App2Bts_GetLocalBtName::operator=(IN const App2Bts_GetLocalBtName& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetLocalBtName::~App2Bts_GetLocalBtName()
{
}

App2Bts_BaseMessage* App2Bts_GetLocalBtName::clone(void) const
{
   return new App2Bts_GetLocalBtName(*this);
}

App2Bts_SetDeviceIdServiceRecord::App2Bts_SetDeviceIdServiceRecord()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SetDeviceIdServiceRecord)
{
   // _serviceRecord: init is done by member constructor
}

App2Bts_SetDeviceIdServiceRecord::App2Bts_SetDeviceIdServiceRecord(IN const App2Bts_SetDeviceIdServiceRecord& ref)
: App2Bts_BaseMessage(ref)
{
   _serviceRecord = ref._serviceRecord;
}

App2Bts_SetDeviceIdServiceRecord& App2Bts_SetDeviceIdServiceRecord::operator=(IN const App2Bts_SetDeviceIdServiceRecord& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _serviceRecord = ref._serviceRecord;

   return *this;
}

App2Bts_SetDeviceIdServiceRecord::~App2Bts_SetDeviceIdServiceRecord()
{
}

App2Bts_BaseMessage* App2Bts_SetDeviceIdServiceRecord::clone(void) const
{
   return new App2Bts_SetDeviceIdServiceRecord(*this);
}

App2Bts_SetDeviceForRestrictedPairingConnecting::App2Bts_SetDeviceForRestrictedPairingConnecting()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SetDeviceForRestrictedPairingConnecting)
{
}

App2Bts_SetDeviceForRestrictedPairingConnecting::App2Bts_SetDeviceForRestrictedPairingConnecting(IN const App2Bts_SetDeviceForRestrictedPairingConnecting& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_SetDeviceForRestrictedPairingConnecting& App2Bts_SetDeviceForRestrictedPairingConnecting::operator=(IN const App2Bts_SetDeviceForRestrictedPairingConnecting& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_SetDeviceForRestrictedPairingConnecting::~App2Bts_SetDeviceForRestrictedPairingConnecting()
{
}

App2Bts_BaseMessage* App2Bts_SetDeviceForRestrictedPairingConnecting::clone(void) const
{
   return new App2Bts_SetDeviceForRestrictedPairingConnecting(*this);
}

void App2Bts_SetDeviceForRestrictedPairingConnecting::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
}

App2Bts_SetLocalAdapterModes::App2Bts_SetLocalAdapterModes()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SetLocalAdapterModes)
{
   _discoverableMode = BTS_MODE_LAST;
   _discoverableTimeout = 0;
   _connectableMode = BTS_MODE_LAST;
   _connectableTimeout = 0;
}

App2Bts_SetLocalAdapterModes::App2Bts_SetLocalAdapterModes(IN const App2Bts_SetLocalAdapterModes& ref)
: App2Bts_BaseMessage(ref)
{
   _discoverableMode = ref._discoverableMode;
   _discoverableTimeout = ref._discoverableTimeout;
   _connectableMode = ref._connectableMode;
   _connectableTimeout = ref._connectableTimeout;
}

App2Bts_SetLocalAdapterModes& App2Bts_SetLocalAdapterModes::operator=(IN const App2Bts_SetLocalAdapterModes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _discoverableMode = ref._discoverableMode;
   _discoverableTimeout = ref._discoverableTimeout;
   _connectableMode = ref._connectableMode;
   _connectableTimeout = ref._connectableTimeout;

   return *this;
}

App2Bts_SetLocalAdapterModes::~App2Bts_SetLocalAdapterModes()
{
}

App2Bts_BaseMessage* App2Bts_SetLocalAdapterModes::clone(void) const
{
   return new App2Bts_SetLocalAdapterModes(*this);
}

App2Bts_GetLocalAdapterModes::App2Bts_GetLocalAdapterModes()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_GetLocalAdapterModes)
{
}

App2Bts_GetLocalAdapterModes::App2Bts_GetLocalAdapterModes(IN const App2Bts_GetLocalAdapterModes& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetLocalAdapterModes& App2Bts_GetLocalAdapterModes::operator=(IN const App2Bts_GetLocalAdapterModes& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetLocalAdapterModes::~App2Bts_GetLocalAdapterModes()
{
}

App2Bts_BaseMessage* App2Bts_GetLocalAdapterModes::clone(void) const
{
   return new App2Bts_GetLocalAdapterModes(*this);
}

App2Bts_StartDiscovery::App2Bts_StartDiscovery()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_StartDiscovery)
{
}

App2Bts_StartDiscovery::App2Bts_StartDiscovery(IN const App2Bts_StartDiscovery& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_StartDiscovery& App2Bts_StartDiscovery::operator=(IN const App2Bts_StartDiscovery& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_StartDiscovery::~App2Bts_StartDiscovery()
{
}

App2Bts_BaseMessage* App2Bts_StartDiscovery::clone(void) const
{
   return new App2Bts_StartDiscovery(*this);
}

App2Bts_StopDiscovery::App2Bts_StopDiscovery()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_StopDiscovery)
{
}

App2Bts_StopDiscovery::App2Bts_StopDiscovery(IN const App2Bts_StopDiscovery& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_StopDiscovery& App2Bts_StopDiscovery::operator=(IN const App2Bts_StopDiscovery& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_StopDiscovery::~App2Bts_StopDiscovery()
{
}

App2Bts_BaseMessage* App2Bts_StopDiscovery::clone(void) const
{
   return new App2Bts_StopDiscovery(*this);
}

App2Bts_GetDiscoveringStatus::App2Bts_GetDiscoveringStatus()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_GetDiscoveringStatus)
{
}

App2Bts_GetDiscoveringStatus::App2Bts_GetDiscoveringStatus(IN const App2Bts_GetDiscoveringStatus& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetDiscoveringStatus& App2Bts_GetDiscoveringStatus::operator=(IN const App2Bts_GetDiscoveringStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetDiscoveringStatus::~App2Bts_GetDiscoveringStatus()
{
}

App2Bts_BaseMessage* App2Bts_GetDiscoveringStatus::clone(void) const
{
   return new App2Bts_GetDiscoveringStatus(*this);
}

App2Bts_StartPairing::App2Bts_StartPairing()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_StartPairing)
{
}

App2Bts_StartPairing::App2Bts_StartPairing(IN const App2Bts_StartPairing& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_StartPairing& App2Bts_StartPairing::operator=(IN const App2Bts_StartPairing& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_StartPairing::~App2Bts_StartPairing()
{
}

App2Bts_BaseMessage* App2Bts_StartPairing::clone(void) const
{
   return new App2Bts_StartPairing(*this);
}

void App2Bts_StartPairing::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_CancelPairing::App2Bts_CancelPairing()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_CancelPairing)
{
}

App2Bts_CancelPairing::App2Bts_CancelPairing(IN const App2Bts_CancelPairing& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_CancelPairing& App2Bts_CancelPairing::operator=(IN const App2Bts_CancelPairing& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_CancelPairing::~App2Bts_CancelPairing()
{
}

App2Bts_BaseMessage* App2Bts_CancelPairing::clone(void) const
{
   return new App2Bts_CancelPairing(*this);
}

void App2Bts_CancelPairing::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_SetPinCode::App2Bts_SetPinCode()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SetPinCode)
{
   // _pinCode: init is done by member constructor
}

App2Bts_SetPinCode::App2Bts_SetPinCode(IN const App2Bts_SetPinCode& ref)
: App2Bts_BaseMessage(ref)
{
   _pinCode = ref._pinCode;
}

App2Bts_SetPinCode& App2Bts_SetPinCode::operator=(IN const App2Bts_SetPinCode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _pinCode = ref._pinCode;

   return *this;
}

App2Bts_SetPinCode::~App2Bts_SetPinCode()
{
}

App2Bts_BaseMessage* App2Bts_SetPinCode::clone(void) const
{
   return new App2Bts_SetPinCode(*this);
}

void App2Bts_SetPinCode::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_ConfirmSecureSimplePairing::App2Bts_ConfirmSecureSimplePairing()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_ConfirmSecureSimplePairing)
{
   _sspMode = BTS_SSP_LAST;
   // _numericValue: init is done by member constructor
   _confirmationMode = BTS_CONFIRM_LAST;
}

App2Bts_ConfirmSecureSimplePairing::App2Bts_ConfirmSecureSimplePairing(IN const App2Bts_ConfirmSecureSimplePairing& ref)
: App2Bts_BaseMessage(ref)
{
   _sspMode = ref._sspMode;
   _numericValue = ref._numericValue;
   _confirmationMode = ref._confirmationMode;
}

App2Bts_ConfirmSecureSimplePairing& App2Bts_ConfirmSecureSimplePairing::operator=(IN const App2Bts_ConfirmSecureSimplePairing& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _sspMode = ref._sspMode;
   _numericValue = ref._numericValue;
   _confirmationMode = ref._confirmationMode;

   return *this;
}

App2Bts_ConfirmSecureSimplePairing::~App2Bts_ConfirmSecureSimplePairing()
{
}

App2Bts_BaseMessage* App2Bts_ConfirmSecureSimplePairing::clone(void) const
{
   return new App2Bts_ConfirmSecureSimplePairing(*this);
}

void App2Bts_ConfirmSecureSimplePairing::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_SetLinkKey::App2Bts_SetLinkKey()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_SetLinkKey)
{
   _linkKeyType = BTS_LINK_KEY_TYPE_LAST;
   // _linkKey: init is done by member constructor
   // _dLinkKey: init is done by member constructor
}

App2Bts_SetLinkKey::App2Bts_SetLinkKey(IN const App2Bts_SetLinkKey& ref)
: App2Bts_BaseMessage(ref)
{
   _linkKeyType = ref._linkKeyType;
   _linkKey = ref._linkKey;
   _dLinkKey = ref._dLinkKey;
}

App2Bts_SetLinkKey& App2Bts_SetLinkKey::operator=(IN const App2Bts_SetLinkKey& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _linkKeyType = ref._linkKeyType;
   _linkKey = ref._linkKey;
   _dLinkKey = ref._dLinkKey;

   return *this;
}

App2Bts_SetLinkKey::~App2Bts_SetLinkKey()
{
}

App2Bts_BaseMessage* App2Bts_SetLinkKey::clone(void) const
{
   return new App2Bts_SetLinkKey(*this);
}

void App2Bts_SetLinkKey::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_ConnectProtocol::App2Bts_ConnectProtocol()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_ConnectProtocol)
{
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
   // _masInstance: init is done by member constructor
   _pageTimeout = 0;
}

App2Bts_ConnectProtocol::App2Bts_ConnectProtocol(IN const App2Bts_ConnectProtocol& ref)
: App2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
   _pageTimeout = ref._pageTimeout;
}

App2Bts_ConnectProtocol& App2Bts_ConnectProtocol::operator=(IN const App2Bts_ConnectProtocol& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
   _pageTimeout = ref._pageTimeout;

   return *this;
}

App2Bts_ConnectProtocol::~App2Bts_ConnectProtocol()
{
}

App2Bts_BaseMessage* App2Bts_ConnectProtocol::clone(void) const
{
   return new App2Bts_ConnectProtocol(*this);
}

void App2Bts_ConnectProtocol::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
   compareItem.protocolId = _protocolId;
   compareItem.sppUuid = _sppUuid;
   compareItem.masInstance = _masInstance;
}

App2Bts_AcceptRemoteProtocolConnect::App2Bts_AcceptRemoteProtocolConnect()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_AcceptRemoteProtocolConnect)
{
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
}

App2Bts_AcceptRemoteProtocolConnect::App2Bts_AcceptRemoteProtocolConnect(IN const App2Bts_AcceptRemoteProtocolConnect& ref)
: App2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
}

App2Bts_AcceptRemoteProtocolConnect& App2Bts_AcceptRemoteProtocolConnect::operator=(IN const App2Bts_AcceptRemoteProtocolConnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;

   return *this;
}

App2Bts_AcceptRemoteProtocolConnect::~App2Bts_AcceptRemoteProtocolConnect()
{
}

App2Bts_BaseMessage* App2Bts_AcceptRemoteProtocolConnect::clone(void) const
{
   return new App2Bts_AcceptRemoteProtocolConnect(*this);
}

void App2Bts_AcceptRemoteProtocolConnect::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
   compareItem.protocolId = _protocolId;
   compareItem.sppUuid = _sppUuid;
}

App2Bts_RejectRemoteProtocolConnect::App2Bts_RejectRemoteProtocolConnect()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_RejectRemoteProtocolConnect)
{
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
}

App2Bts_RejectRemoteProtocolConnect::App2Bts_RejectRemoteProtocolConnect(IN const App2Bts_RejectRemoteProtocolConnect& ref)
: App2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
}

App2Bts_RejectRemoteProtocolConnect& App2Bts_RejectRemoteProtocolConnect::operator=(IN const App2Bts_RejectRemoteProtocolConnect& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;

   return *this;
}

App2Bts_RejectRemoteProtocolConnect::~App2Bts_RejectRemoteProtocolConnect()
{
}

App2Bts_BaseMessage* App2Bts_RejectRemoteProtocolConnect::clone(void) const
{
   return new App2Bts_RejectRemoteProtocolConnect(*this);
}

void App2Bts_RejectRemoteProtocolConnect::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
   compareItem.protocolId = _protocolId;
   compareItem.sppUuid = _sppUuid;
}

App2Bts_DisconnectProtocol::App2Bts_DisconnectProtocol()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_DisconnectProtocol)
{
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
   // _masInstance: init is done by member constructor
   _pauseBtStreaming = false;
}

App2Bts_DisconnectProtocol::App2Bts_DisconnectProtocol(IN const App2Bts_DisconnectProtocol& ref)
: App2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
   _pauseBtStreaming = ref._pauseBtStreaming;
}

App2Bts_DisconnectProtocol& App2Bts_DisconnectProtocol::operator=(IN const App2Bts_DisconnectProtocol& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
   _pauseBtStreaming = ref._pauseBtStreaming;

   return *this;
}

App2Bts_DisconnectProtocol::~App2Bts_DisconnectProtocol()
{
}

App2Bts_BaseMessage* App2Bts_DisconnectProtocol::clone(void) const
{
   return new App2Bts_DisconnectProtocol(*this);
}

void App2Bts_DisconnectProtocol::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
   compareItem.protocolId = _protocolId;
   compareItem.sppUuid = _sppUuid;
   compareItem.masInstance = _masInstance;
}

App2Bts_DisconnectDevice::App2Bts_DisconnectDevice()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_DisconnectDevice)
{
   _pauseBtStreaming = false;
}

App2Bts_DisconnectDevice::App2Bts_DisconnectDevice(IN const App2Bts_DisconnectDevice& ref)
: App2Bts_BaseMessage(ref)
{
   _pauseBtStreaming = ref._pauseBtStreaming;
}

App2Bts_DisconnectDevice& App2Bts_DisconnectDevice::operator=(IN const App2Bts_DisconnectDevice& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _pauseBtStreaming = ref._pauseBtStreaming;

   return *this;
}

App2Bts_DisconnectDevice::~App2Bts_DisconnectDevice()
{
}

App2Bts_BaseMessage* App2Bts_DisconnectDevice::clone(void) const
{
   return new App2Bts_DisconnectDevice(*this);
}

void App2Bts_DisconnectDevice::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_GetProtocolConnectionStatus::App2Bts_GetProtocolConnectionStatus()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_GetProtocolConnectionStatus)
{
   _protocolId = BTS_PROTO_LAST;
   // _sppUuid: init is done by member constructor
   // _masInstance: init is done by member constructor
}

App2Bts_GetProtocolConnectionStatus::App2Bts_GetProtocolConnectionStatus(IN const App2Bts_GetProtocolConnectionStatus& ref)
: App2Bts_BaseMessage(ref)
{
   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;
}

App2Bts_GetProtocolConnectionStatus& App2Bts_GetProtocolConnectionStatus::operator=(IN const App2Bts_GetProtocolConnectionStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _protocolId = ref._protocolId;
   _sppUuid = ref._sppUuid;
   _masInstance = ref._masInstance;

   return *this;
}

App2Bts_GetProtocolConnectionStatus::~App2Bts_GetProtocolConnectionStatus()
{
}

App2Bts_BaseMessage* App2Bts_GetProtocolConnectionStatus::clone(void) const
{
   return new App2Bts_GetProtocolConnectionStatus(*this);
}

void App2Bts_GetProtocolConnectionStatus::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
   compareItem.protocolId = _protocolId;
   compareItem.sppUuid = _sppUuid;
   compareItem.masInstance = _masInstance;
}

App2Bts_GetDeviceConnectionStatus::App2Bts_GetDeviceConnectionStatus()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_GetDeviceConnectionStatus)
{
}

App2Bts_GetDeviceConnectionStatus::App2Bts_GetDeviceConnectionStatus(IN const App2Bts_GetDeviceConnectionStatus& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_GetDeviceConnectionStatus& App2Bts_GetDeviceConnectionStatus::operator=(IN const App2Bts_GetDeviceConnectionStatus& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_GetDeviceConnectionStatus::~App2Bts_GetDeviceConnectionStatus()
{
}

App2Bts_BaseMessage* App2Bts_GetDeviceConnectionStatus::clone(void) const
{
   return new App2Bts_GetDeviceConnectionStatus(*this);
}

void App2Bts_GetDeviceConnectionStatus::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_StartRemoteServiceSearch::App2Bts_StartRemoteServiceSearch()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_StartRemoteServiceSearch)
{
   _searchType = BTS_SEARCH_LAST;
   _rejectIfNotConnected = false;
}

App2Bts_StartRemoteServiceSearch::App2Bts_StartRemoteServiceSearch(IN const App2Bts_StartRemoteServiceSearch& ref)
: App2Bts_BaseMessage(ref)
{
   _searchType = ref._searchType;
   _rejectIfNotConnected = ref._rejectIfNotConnected;
}

App2Bts_StartRemoteServiceSearch& App2Bts_StartRemoteServiceSearch::operator=(IN const App2Bts_StartRemoteServiceSearch& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _searchType = ref._searchType;
   _rejectIfNotConnected = ref._rejectIfNotConnected;

   return *this;
}

App2Bts_StartRemoteServiceSearch::~App2Bts_StartRemoteServiceSearch()
{
}

App2Bts_BaseMessage* App2Bts_StartRemoteServiceSearch::clone(void) const
{
   return new App2Bts_StartRemoteServiceSearch(*this);
}

void App2Bts_StartRemoteServiceSearch::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
   compareItem.searchType = _searchType;
}

App2Bts_CancelRemoteServiceSearch::App2Bts_CancelRemoteServiceSearch()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_CancelRemoteServiceSearch)
{
   _searchType = BTS_SEARCH_LAST;
}

App2Bts_CancelRemoteServiceSearch::App2Bts_CancelRemoteServiceSearch(IN const App2Bts_CancelRemoteServiceSearch& ref)
: App2Bts_BaseMessage(ref)
{
   _searchType = ref._searchType;
}

App2Bts_CancelRemoteServiceSearch& App2Bts_CancelRemoteServiceSearch::operator=(IN const App2Bts_CancelRemoteServiceSearch& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   _searchType = ref._searchType;

   return *this;
}

App2Bts_CancelRemoteServiceSearch::~App2Bts_CancelRemoteServiceSearch()
{
}

App2Bts_BaseMessage* App2Bts_CancelRemoteServiceSearch::clone(void) const
{
   return new App2Bts_CancelRemoteServiceSearch(*this);
}

void App2Bts_CancelRemoteServiceSearch::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
   compareItem.searchType = _searchType;
}

App2Bts_QueryRemoteName::App2Bts_QueryRemoteName()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_QueryRemoteName)
{
}

App2Bts_QueryRemoteName::App2Bts_QueryRemoteName(IN const App2Bts_QueryRemoteName& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_QueryRemoteName& App2Bts_QueryRemoteName::operator=(IN const App2Bts_QueryRemoteName& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_QueryRemoteName::~App2Bts_QueryRemoteName()
{
}

App2Bts_BaseMessage* App2Bts_QueryRemoteName::clone(void) const
{
   return new App2Bts_QueryRemoteName(*this);
}

void App2Bts_QueryRemoteName::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_RequestLinkQuality::App2Bts_RequestLinkQuality()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_RequestLinkQuality)
{
}

App2Bts_RequestLinkQuality::App2Bts_RequestLinkQuality(IN const App2Bts_RequestLinkQuality& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_RequestLinkQuality& App2Bts_RequestLinkQuality::operator=(IN const App2Bts_RequestLinkQuality& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_RequestLinkQuality::~App2Bts_RequestLinkQuality()
{
}

App2Bts_BaseMessage* App2Bts_RequestLinkQuality::clone(void) const
{
   return new App2Bts_RequestLinkQuality(*this);
}

void App2Bts_RequestLinkQuality::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_StartTestMode::App2Bts_StartTestMode()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_StartTestMode)
{
}

App2Bts_StartTestMode::App2Bts_StartTestMode(IN const App2Bts_StartTestMode& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_StartTestMode& App2Bts_StartTestMode::operator=(IN const App2Bts_StartTestMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_StartTestMode::~App2Bts_StartTestMode()
{
}

App2Bts_BaseMessage* App2Bts_StartTestMode::clone(void) const
{
   return new App2Bts_StartTestMode(*this);
}

void App2Bts_StartTestMode::getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const
{
   // set available data
   compareItem.opCode = _opCode;
   compareItem.deviceAddress = _deviceAddress;
}

App2Bts_StopTestMode::App2Bts_StopTestMode()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_StopTestMode)
{
}

App2Bts_StopTestMode::App2Bts_StopTestMode(IN const App2Bts_StopTestMode& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_StopTestMode& App2Bts_StopTestMode::operator=(IN const App2Bts_StopTestMode& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_StopTestMode::~App2Bts_StopTestMode()
{
}

App2Bts_BaseMessage* App2Bts_StopTestMode::clone(void) const
{
   return new App2Bts_StopTestMode(*this);
}

App2Bts_RequestTestModeLinkQuality::App2Bts_RequestTestModeLinkQuality()
: App2Bts_BaseMessage(BTS_FB_CONNECTION, App2BtsOC_RequestTestModeLinkQuality)
{
}

App2Bts_RequestTestModeLinkQuality::App2Bts_RequestTestModeLinkQuality(IN const App2Bts_RequestTestModeLinkQuality& ref)
: App2Bts_BaseMessage(ref)
{
}

App2Bts_RequestTestModeLinkQuality& App2Bts_RequestTestModeLinkQuality::operator=(IN const App2Bts_RequestTestModeLinkQuality& ref)
{
   if(this == &ref)
   {
      return *this;
   }

   App2Bts_BaseMessage::operator=(ref);

   return *this;
}

App2Bts_RequestTestModeLinkQuality::~App2Bts_RequestTestModeLinkQuality()
{
}

App2Bts_BaseMessage* App2Bts_RequestTestModeLinkQuality::clone(void) const
{
   return new App2Bts_RequestTestModeLinkQuality(*this);
}

} //btstackif
