/**
 * @file App2Bts_Connection.h
 *
 * @par SW-Component
 * Messages
 *
 * @brief Application to BtStackIf messages for function block BTS_FB_CONNECTION.
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *
 * @par
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 *
 * @details Declaration of messages for function block BTS_FB_CONNECTION.
 */

#ifndef _APP_2_BTS_CONNECTION_MSG_H_
#define _APP_2_BTS_CONNECTION_MSG_H_

#include "App2Bts_BaseMessage.h"

namespace btstackif {

/**
 *
 */
class App2Bts_StartInternalCommunication : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_StartInternalCommunication();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_StartInternalCommunication(IN const App2Bts_StartInternalCommunication& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_StartInternalCommunication& operator=(IN const App2Bts_StartInternalCommunication& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_StartInternalCommunication();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_TriggerFbConnectionInitialized : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_TriggerFbConnectionInitialized();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_TriggerFbConnectionInitialized(IN const App2Bts_TriggerFbConnectionInitialized& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_TriggerFbConnectionInitialized& operator=(IN const App2Bts_TriggerFbConnectionInitialized& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_TriggerFbConnectionInitialized();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_SwitchBluetoothOnOff : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SwitchBluetoothOnOff();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SwitchBluetoothOnOff(IN const App2Bts_SwitchBluetoothOnOff& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SwitchBluetoothOnOff& operator=(IN const App2Bts_SwitchBluetoothOnOff& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SwitchBluetoothOnOff();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setBluetoothMode(IN const BTSBluetoothMode bluetoothMode) { _bluetoothMode = bluetoothMode; }
   inline void setAdapterMode(IN const BTSAdapterMode adapterMode) { _adapterMode = adapterMode; }

   inline BTSBluetoothMode getBluetoothMode(void) const { return _bluetoothMode; }
   inline BTSAdapterMode getAdapterMode(void) const { return _adapterMode; }

private:
   BTSBluetoothMode _bluetoothMode; /**< parameter bluetooth mode */
   BTSAdapterMode _adapterMode; /**< parameter adapter mode */
};

/**
 *
 */
class App2Bts_GetBluetoothOnOffStatus : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetBluetoothOnOffStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetBluetoothOnOffStatus(IN const App2Bts_GetBluetoothOnOffStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetBluetoothOnOffStatus& operator=(IN const App2Bts_GetBluetoothOnOffStatus& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetBluetoothOnOffStatus();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_SwitchBluetoothHardwareOnOff : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SwitchBluetoothHardwareOnOff();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SwitchBluetoothHardwareOnOff(IN const App2Bts_SwitchBluetoothHardwareOnOff& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SwitchBluetoothHardwareOnOff& operator=(IN const App2Bts_SwitchBluetoothHardwareOnOff& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SwitchBluetoothHardwareOnOff();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setBluetoothMode(IN const BTSBluetoothMode bluetoothMode) { _bluetoothMode = bluetoothMode; }

   inline BTSBluetoothMode getBluetoothMode(void) const { return _bluetoothMode; }

private:
   BTSBluetoothMode _bluetoothMode; /**< parameter bluetooth mode */
};

/**
 *
 */
class App2Bts_SetLocalBtName : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetLocalBtName();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetLocalBtName(IN const App2Bts_SetLocalBtName& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetLocalBtName& operator=(IN const App2Bts_SetLocalBtName& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetLocalBtName();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setDeviceName(IN const BTSDeviceName& adapterName) { _adapterName = adapterName; }

   inline void getDeviceName(OUT BTSDeviceName& adapterName) const { adapterName = _adapterName; }
   inline const BTSDeviceName& getDeviceName(void) const { return _adapterName; }
   inline BTSDeviceName& getDeviceNameMutable(void) { return _adapterName; }

private:
   BTSDeviceName _adapterName; /**< parameter adapter name */
};

/**
 *
 */
class App2Bts_GetLocalBtName : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetLocalBtName();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetLocalBtName(IN const App2Bts_GetLocalBtName& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetLocalBtName& operator=(IN const App2Bts_GetLocalBtName& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetLocalBtName();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;
};

/**
 *
 */
class App2Bts_SetDeviceIdServiceRecord : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetDeviceIdServiceRecord();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetDeviceIdServiceRecord(IN const App2Bts_SetDeviceIdServiceRecord& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetDeviceIdServiceRecord& operator=(IN const App2Bts_SetDeviceIdServiceRecord& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetDeviceIdServiceRecord();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setDeviceIdServiceRecord(IN const BTSDeviceIdServiceRecord& serviceRecord) { _serviceRecord = serviceRecord; }

   inline void getDeviceIdServiceRecord(OUT BTSDeviceIdServiceRecord& serviceRecord) const { serviceRecord = _serviceRecord; }
   inline const BTSDeviceIdServiceRecord& getDeviceIdServiceRecord(void) const { return _serviceRecord; }
   inline BTSDeviceIdServiceRecord& getDeviceIdServiceRecordMutable(void) { return _serviceRecord; }

private:
   BTSDeviceIdServiceRecord _serviceRecord; /**< parameter service record */
};

/**
 *
 */
class App2Bts_SetDeviceForRestrictedPairingConnecting : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetDeviceForRestrictedPairingConnecting();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetDeviceForRestrictedPairingConnecting(IN const App2Bts_SetDeviceForRestrictedPairingConnecting& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetDeviceForRestrictedPairingConnecting& operator=(IN const App2Bts_SetDeviceForRestrictedPairingConnecting& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetDeviceForRestrictedPairingConnecting();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_SetLocalAdapterModes : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetLocalAdapterModes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetLocalAdapterModes(IN const App2Bts_SetLocalAdapterModes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetLocalAdapterModes& operator=(IN const App2Bts_SetLocalAdapterModes& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetLocalAdapterModes();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setDiscoverableMode(IN const BTSLocalMode discoverableMode) { _discoverableMode = discoverableMode; }
   inline void setDiscoverableTimeout(IN const BTSDiscoverableTimeout discoverableTimeout) { _discoverableTimeout = discoverableTimeout; }
   inline void setConnectableMode(IN const BTSLocalMode connectableMode) { _connectableMode = connectableMode; }
   inline void setConnectableTimeout(IN const BTSConnectableTimeout connectableTimeout) { _connectableTimeout = connectableTimeout; }

   inline BTSLocalMode getDiscoverableMode(void) const { return _discoverableMode; }
   inline BTSDiscoverableTimeout getDiscoverableTimeout(void) const { return _discoverableTimeout; }
   inline BTSLocalMode getConnectableMode(void) const { return _connectableMode; }
   inline BTSConnectableTimeout getConnectableTimeout(void) const { return _connectableTimeout; }

private:
   BTSLocalMode _discoverableMode; /**< parameter discoverable mode */
   BTSDiscoverableTimeout _discoverableTimeout; /**< parameter discoverable timeout */
   BTSLocalMode _connectableMode; /**< parameter connectable mode */
   BTSConnectableTimeout _connectableTimeout; /**< parameter connectable timeout */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_GetLocalAdapterModes : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetLocalAdapterModes();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetLocalAdapterModes(IN const App2Bts_GetLocalAdapterModes& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetLocalAdapterModes& operator=(IN const App2Bts_GetLocalAdapterModes& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetLocalAdapterModes();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_StartDiscovery : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_StartDiscovery();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_StartDiscovery(IN const App2Bts_StartDiscovery& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_StartDiscovery& operator=(IN const App2Bts_StartDiscovery& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_StartDiscovery();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_StopDiscovery : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_StopDiscovery();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_StopDiscovery(IN const App2Bts_StopDiscovery& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_StopDiscovery& operator=(IN const App2Bts_StopDiscovery& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_StopDiscovery();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_GetDiscoveringStatus : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetDiscoveringStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetDiscoveringStatus(IN const App2Bts_GetDiscoveringStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetDiscoveringStatus& operator=(IN const App2Bts_GetDiscoveringStatus& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetDiscoveringStatus();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_StartPairing : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_StartPairing();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_StartPairing(IN const App2Bts_StartPairing& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_StartPairing& operator=(IN const App2Bts_StartPairing& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_StartPairing();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_CancelPairing : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_CancelPairing();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_CancelPairing(IN const App2Bts_CancelPairing& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_CancelPairing& operator=(IN const App2Bts_CancelPairing& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_CancelPairing();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_SetPinCode : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetPinCode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetPinCode(IN const App2Bts_SetPinCode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetPinCode& operator=(IN const App2Bts_SetPinCode& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetPinCode();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setPinCode(IN const BTSPinCode& pinCode) { _pinCode = pinCode; }

   inline void getPinCode(OUT BTSPinCode& pinCode) const { pinCode = _pinCode; }
   inline const BTSPinCode& getPinCode(void) const { return _pinCode; }
   inline BTSPinCode& getPinCodeMutable(void) { return _pinCode; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSPinCode _pinCode; /**< parameter pin code */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_ConfirmSecureSimplePairing : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_ConfirmSecureSimplePairing();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_ConfirmSecureSimplePairing(IN const App2Bts_ConfirmSecureSimplePairing& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_ConfirmSecureSimplePairing& operator=(IN const App2Bts_ConfirmSecureSimplePairing& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_ConfirmSecureSimplePairing();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setSspMode(IN const BTSSspMode sspMode) { _sspMode = sspMode; }
   inline void setNumericValue(IN const BTSNumericValue& numericValue) { _numericValue = numericValue; }
   inline void setConfirmationMode(IN const BTSConfirmationMode confirmationMode) { _confirmationMode = confirmationMode; }

   inline BTSSspMode getSspMode(void) const { return _sspMode; }
   inline void getNumericValue(OUT BTSNumericValue& numericValue) const { numericValue = _numericValue; }
   inline const BTSNumericValue& getNumericValue(void) const { return _numericValue; }
   inline BTSNumericValue& getNumericValueMutable(void) { return _numericValue; }
   inline BTSConfirmationMode getConfirmationMode(void) const { return _confirmationMode; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSSspMode _sspMode; /**< parameter ssp mode */
   BTSNumericValue _numericValue; /**< parameter numeric value */
   BTSConfirmationMode _confirmationMode; /**< parameter confirmation mode */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_SetLinkKey : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_SetLinkKey();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_SetLinkKey(IN const App2Bts_SetLinkKey& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_SetLinkKey& operator=(IN const App2Bts_SetLinkKey& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_SetLinkKey();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setLinkKeyType(IN const BTSLinkKeyType linkKeyType) { _linkKeyType = linkKeyType; }
   inline void setLinkKey(IN const BTSLinkKey& linkKey) { _linkKey = linkKey; }
   inline void setDLinkKey(IN const BTSDLinkKey& dLinkKey) { _dLinkKey = dLinkKey; }

   inline BTSLinkKeyType getLinkKeyType(void) const { return _linkKeyType; }
   inline void getLinkKey(OUT BTSLinkKey& linkKey) const { linkKey = _linkKey; }
   inline const BTSLinkKey& getLinkKey(void) const { return _linkKey; }
   inline BTSLinkKey& getLinkKeyMutable(void) { return _linkKey; }
   inline void getDLinkKey(OUT BTSDLinkKey& dLinkKey) const { dLinkKey = _dLinkKey; }
   inline const BTSDLinkKey& getDLinkKey(void) const { return _dLinkKey; }
   inline BTSDLinkKey& getDLinkKeyMutable(void) { return _dLinkKey; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSLinkKeyType _linkKeyType; /**< parameter link key type */
   BTSLinkKey _linkKey; /**< parameter link key */
   BTSDLinkKey _dLinkKey; /**< parameter d link key */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_ConnectProtocol : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_ConnectProtocol();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_ConnectProtocol(IN const App2Bts_ConnectProtocol& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_ConnectProtocol& operator=(IN const App2Bts_ConnectProtocol& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_ConnectProtocol();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }
   inline void setMasInstanceName(IN const BTSMasInstanceName& masInstance) { _masInstance = masInstance; }
   inline void setTimeValue(IN const BTSTimeValue pageTimeout) { _pageTimeout = pageTimeout; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }
   inline void getMasInstanceName(OUT BTSMasInstanceName& masInstance) const { masInstance = _masInstance; }
   inline const BTSMasInstanceName& getMasInstanceName(void) const { return _masInstance; }
   inline BTSMasInstanceName& getMasInstanceNameMutable(void) { return _masInstance; }
   inline BTSTimeValue getTimeValue(void) const { return _pageTimeout; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   BTSMasInstanceName _masInstance; /**< parameter mas instance */
   BTSTimeValue _pageTimeout; /**< parameter page timeout */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_AcceptRemoteProtocolConnect : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_AcceptRemoteProtocolConnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_AcceptRemoteProtocolConnect(IN const App2Bts_AcceptRemoteProtocolConnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_AcceptRemoteProtocolConnect& operator=(IN const App2Bts_AcceptRemoteProtocolConnect& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_AcceptRemoteProtocolConnect();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_RejectRemoteProtocolConnect : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_RejectRemoteProtocolConnect();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_RejectRemoteProtocolConnect(IN const App2Bts_RejectRemoteProtocolConnect& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_RejectRemoteProtocolConnect& operator=(IN const App2Bts_RejectRemoteProtocolConnect& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_RejectRemoteProtocolConnect();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_DisconnectProtocol : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_DisconnectProtocol();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_DisconnectProtocol(IN const App2Bts_DisconnectProtocol& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_DisconnectProtocol& operator=(IN const App2Bts_DisconnectProtocol& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_DisconnectProtocol();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }
   inline void setMasInstanceName(IN const BTSMasInstanceName& masInstance) { _masInstance = masInstance; }
   inline void setPauseBtStreaming(IN const bool pauseBtStreaming) { _pauseBtStreaming = pauseBtStreaming; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }
   inline void getMasInstanceName(OUT BTSMasInstanceName& masInstance) const { masInstance = _masInstance; }
   inline const BTSMasInstanceName& getMasInstanceName(void) const { return _masInstance; }
   inline BTSMasInstanceName& getMasInstanceNameMutable(void) { return _masInstance; }
   inline bool getPauseBtStreaming(void) const { return _pauseBtStreaming; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   BTSMasInstanceName _masInstance; /**< parameter mas instance */
   bool _pauseBtStreaming; /**< parameter pause bt streaming */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_DisconnectDevice : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_DisconnectDevice();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_DisconnectDevice(IN const App2Bts_DisconnectDevice& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_DisconnectDevice& operator=(IN const App2Bts_DisconnectDevice& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_DisconnectDevice();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setPauseBtStreaming(IN const bool pauseBtStreaming) { _pauseBtStreaming = pauseBtStreaming; }

   inline bool getPauseBtStreaming(void) const { return _pauseBtStreaming; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   bool _pauseBtStreaming; /**< parameter pause bt streaming */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_GetProtocolConnectionStatus : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetProtocolConnectionStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetProtocolConnectionStatus(IN const App2Bts_GetProtocolConnectionStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetProtocolConnectionStatus& operator=(IN const App2Bts_GetProtocolConnectionStatus& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetProtocolConnectionStatus();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setProtocolId(IN const BTSProtocolId protocolId) { _protocolId = protocolId; }
   inline void setUuid(IN const BTSUuid& sppUuid) { _sppUuid = sppUuid; }
   inline void setMasInstanceName(IN const BTSMasInstanceName& masInstance) { _masInstance = masInstance; }

   inline BTSProtocolId getProtocolId(void) const { return _protocolId; }
   inline void getUuid(OUT BTSUuid& sppUuid) const { sppUuid = _sppUuid; }
   inline const BTSUuid& getUuid(void) const { return _sppUuid; }
   inline BTSUuid& getUuidMutable(void) { return _sppUuid; }
   inline void getMasInstanceName(OUT BTSMasInstanceName& masInstance) const { masInstance = _masInstance; }
   inline const BTSMasInstanceName& getMasInstanceName(void) const { return _masInstance; }
   inline BTSMasInstanceName& getMasInstanceNameMutable(void) { return _masInstance; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSProtocolId _protocolId; /**< parameter protocol id */
   BTSUuid _sppUuid; /**< parameter spp uuid */
   BTSMasInstanceName _masInstance; /**< parameter mas instance */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_GetDeviceConnectionStatus : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_GetDeviceConnectionStatus();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_GetDeviceConnectionStatus(IN const App2Bts_GetDeviceConnectionStatus& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_GetDeviceConnectionStatus& operator=(IN const App2Bts_GetDeviceConnectionStatus& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_GetDeviceConnectionStatus();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_StartRemoteServiceSearch : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_StartRemoteServiceSearch();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_StartRemoteServiceSearch(IN const App2Bts_StartRemoteServiceSearch& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_StartRemoteServiceSearch& operator=(IN const App2Bts_StartRemoteServiceSearch& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_StartRemoteServiceSearch();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setSearchType(IN const BTSSearchType searchType) { _searchType = searchType; }
   inline void setRejectIfNotConnected(IN const bool rejectIfNotConnected) { _rejectIfNotConnected = rejectIfNotConnected; }

   inline BTSSearchType getSearchType(void) const { return _searchType; }
   inline bool getRejectIfNotConnected(void) const { return _rejectIfNotConnected; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSSearchType _searchType; /**< parameter search type */
   bool _rejectIfNotConnected; /**< parameter reject if not connected */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_CancelRemoteServiceSearch : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_CancelRemoteServiceSearch();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_CancelRemoteServiceSearch(IN const App2Bts_CancelRemoteServiceSearch& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_CancelRemoteServiceSearch& operator=(IN const App2Bts_CancelRemoteServiceSearch& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_CancelRemoteServiceSearch();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   inline void setSearchType(IN const BTSSearchType searchType) { _searchType = searchType; }

   inline BTSSearchType getSearchType(void) const { return _searchType; }

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

private:
   // see base class: BTSBDAddress _deviceAddress;
   BTSSearchType _searchType; /**< parameter search type */
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_QueryRemoteName : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_QueryRemoteName();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_QueryRemoteName(IN const App2Bts_QueryRemoteName& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_QueryRemoteName& operator=(IN const App2Bts_QueryRemoteName& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_QueryRemoteName();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_RequestLinkQuality : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_RequestLinkQuality();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_RequestLinkQuality(IN const App2Bts_RequestLinkQuality& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_RequestLinkQuality& operator=(IN const App2Bts_RequestLinkQuality& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_RequestLinkQuality();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_StartTestMode : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_StartTestMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_StartTestMode(IN const App2Bts_StartTestMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_StartTestMode& operator=(IN const App2Bts_StartTestMode& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_StartTestMode();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

   virtual void getCompareItem(OUT BTSApp2BtsMessageCompareItem& compareItem) const;

// private:
   // see base class: BTSBDAddress _deviceAddress;
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_StopTestMode : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_StopTestMode();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_StopTestMode(IN const App2Bts_StopTestMode& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_StopTestMode& operator=(IN const App2Bts_StopTestMode& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_StopTestMode();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSSessionHandle _sessionHandle;
};

/**
 *
 */
class App2Bts_RequestTestModeLinkQuality : public App2Bts_BaseMessage
{
public:
   /**************************************************************************
    Constructor / destructor
    **************************************************************************/
   /**
    * Constructor.
    */
   App2Bts_RequestTestModeLinkQuality();

   /**
    * Copy constructor.
    *
    * @param[in] ref: reference of message to be copied
    */
   App2Bts_RequestTestModeLinkQuality(IN const App2Bts_RequestTestModeLinkQuality& ref);

   /**
    * Assignment operator.
    *
    * @param[in] ref: reference of message to be assigned
    */
   App2Bts_RequestTestModeLinkQuality& operator=(IN const App2Bts_RequestTestModeLinkQuality& ref);

   /**
    * Destructor.
    */
   virtual ~App2Bts_RequestTestModeLinkQuality();

   /**
    * Trace function for input parameters.
    */
   virtual void doInputTrace(void);

   /**
    * Returns copy of the message object.
    *
    * @return = copy of the message object (pointer, created by new)
    */
   virtual App2Bts_BaseMessage* clone(void) const;

// private:
   // see base class: BTSSessionHandle _sessionHandle;
};

} //btstackif

#endif //_APP_2_BTS_CONNECTION_MSG_H_
