/**
 * @file FC_Bluetooth_main.cpp
 * @author 
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for CCABluetoothApplication
 *
 * @{
 */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

//#define VARIANT_S_FTR_ENABLE_LOAD_REGISTRY
#undef VARIANT_S_FTR_ENABLE_LOAD_REGISTRY
#ifdef VARIANT_S_FTR_ENABLE_LOAD_REGISTRY
#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"
#endif

#include "FC_Bluetooth_main.h"
#include "FC_Bluetooth_CCAService.h"
#include "FC_Bluetooth_clienthandler_MediaPlayer.h"
#include "FC_Bluetooth_clienthandler_SpmCore.h"
#include "FC_Bluetooth_clienthandler_DefSetHandler.h"
#include "FC_Bluetooth_clienthandler_Diaglib.h"
#include "FC_Bluetooth_clienthandler_Diaglog.h"
#include "FC_Bluetooth_clienthandler_Phone.h"
#include "FC_Bluetooth_AudioRouting.h"
#include "FC_Bluetooth_TestCommand.h"
#include "BmCoreFactory.h"
#include "IBmCoreRequestIf.h"

#include "FunctionTracer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FC_Bluetooth_main.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

// Static self reference to be used in function callbacks.
fc_bluetooth_tclApp* fc_bluetooth_tclApp::_bluetoothApp = NULL;

/**
 * Constructor
 */
fc_bluetooth_tclApp::fc_bluetooth_tclApp():ahl_tclBaseOneThreadApp()
{
  ENTRY

  ETG_TRACE_USR1(("fc_bluetooth_tclApp : fc_bluetooth_tclApp entered"));

  fc_bluetooth_tclApp::_bluetoothApp = this;

  _bluetoothCCAService = NULL;
  _outputWrapper = NULL;
  _phoneclienthandler = NULL;
  _mediaplayerclienthandler = NULL;
  _spmcoreclienthandler = NULL;
  _diaglibservice = NULL;
  _diaglibclienthandler =NULL;
  _diaglogclienthandler =NULL;
  _defsetclienthandler  = NULL;
  _audiorouting = NULL;
  _bmCoreRequestIf = NULL;
  _testCommand = NULL;
}

/**
 * Destructor
 */
fc_bluetooth_tclApp::~fc_bluetooth_tclApp() 
{
   ENTRY

   ETG_TRACE_USR1(("fc_bluetooth_tclApp : ~fc_bluetooth_tclApp entered"));

   if (_audiorouting != NULL)
   {
      OSAL_DELETE _audiorouting;
      _audiorouting = NULL;
   }

   if (_diaglibservice != OSAL_NULL)
   {
      OSAL_DELETE _diaglibservice;
      _diaglibservice = OSAL_NULL;
   }

   if (_diaglibclienthandler != OSAL_NULL)
   {
      OSAL_DELETE _diaglibclienthandler;
      _diaglibclienthandler = OSAL_NULL;
   }

   if (_diaglogclienthandler != OSAL_NULL)
   {
      OSAL_DELETE _diaglogclienthandler;
      _diaglogclienthandler = OSAL_NULL;
   }

   if (_mediaplayerclienthandler != NULL)
   {
      OSAL_DELETE _mediaplayerclienthandler;
      _mediaplayerclienthandler = NULL;
   }

   if (_spmcoreclienthandler != NULL)
   {
      OSAL_DELETE _spmcoreclienthandler;
      _spmcoreclienthandler = NULL;
   }

   if (_defsetclienthandler != NULL)
   {
      OSAL_DELETE _defsetclienthandler;
      _defsetclienthandler = NULL;
   }

   if (_bluetoothCCAService != NULL)
   {
      OSAL_DELETE _bluetoothCCAService;
      _bluetoothCCAService = NULL;
   }

   if (_phoneclienthandler != NULL)
   {
      OSAL_DELETE _phoneclienthandler;
      _phoneclienthandler = NULL;
   }

   if (_outputWrapper != NULL)
   {
      OSAL_DELETE _outputWrapper;
      _outputWrapper = NULL;
   }

   BmCoreFactory::getInstance().destroyBmCoreRequestIfInstance();
   _bmCoreRequestIf = NULL;

   if (_testCommand != NULL)
   {
      // deregistration of TTFis channel shall be done after destroying BM core instance
      _testCommand->destroy();
      OSAL_DELETE _testCommand;
      _testCommand = NULL;
   }

   if(_bluetoothApp)
   {
      OSAL_DELETE fc_bluetooth_tclApp::_bluetoothApp;
      fc_bluetooth_tclApp::_bluetoothApp = NULL;
   }
}

/**
 * fc_bluetooth_tclApp::bOnInit()
 */
tBool fc_bluetooth_tclApp::bOnInit()
{
    ENTRY
    tBool bSuccess = TRUE;

    ETG_TRACE_USR1(("fc_bluetooth_tclApp : bOnInit entered"));

    _bluetoothCCAService = OSAL_NEW FC_Bluetooth_tclCCAService(this);
    if (NULL == _bluetoothCCAService)
    {
        bSuccess = FALSE;
        FATAL_M_ASSERT_ALWAYS();
    }

    _testCommand = OSAL_NEW FC_Bluetooth_TestCommand(this);
    if (NULL == _testCommand)
    {
       bSuccess = FALSE;
       FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
       // registration of TTFis channel shall be done before creating BM core instance
       _testCommand->create(TR_TTFIS_CONNECTIVITY);
    }

   _bmCoreRequestIf = BmCoreFactory::getInstance().getBmCoreRequestIfInstance();

   if (_bmCoreRequestIf)
   {
      _outputWrapper = OSAL_NEW CCAOutputWrapper(this);

      if (NULL == _outputWrapper)
      {
         bSuccess = FALSE;
         FATAL_M_ASSERT_ALWAYS();
      }
      else
      {
         _bmCoreRequestIf->registerBmCoreCallbackIf(_outputWrapper);
      }

      BmResult result = _bmCoreRequestIf->initializeBmCore();

      if (BM_RESULT_OK != result)
      {
         bSuccess = FALSE;
         FATAL_M_ASSERT_ALWAYS();
      }
   }
   else
   {
      bSuccess = false;
      FATAL_M_ASSERT_ALWAYS();
   }

   _diaglibservice = OSAL_NEW diaglib::tclServiceDiaglib(this, 1);
   if (_diaglibservice == NULL)
   {
      ETG_TRACE_FATAL(( "bOnInit: creation of diaglib service failed" ));
   }
   else
   {
      _diaglibclienthandler = OSAL_NEW fc_bluetooth_tclClientHandler_Diaglib(this, _diaglibservice);
      if (NULL == _diaglibclienthandler)
      {
         ETG_TRACE_FATAL(( "bOnInit: creation of diaglib bluetooth handler failed" ));
         bSuccess = FALSE;
      }

      _diaglogclienthandler = OSAL_NEW fc_bluetooth_tclClientHandler_Diaglog(this);
      if (NULL == _diaglogclienthandler)
      {
         ETG_TRACE_FATAL(( "bOnInit: creation of diaglog bluetooth handler failed" ));
         bSuccess = FALSE;
      }

      _defsetclienthandler = OSAL_NEW fc_bluetooth_tclClientHandler_DefSetHandler(_diaglibservice);
      if (NULL == _defsetclienthandler)
      {
         bSuccess = FALSE;
         FATAL_M_ASSERT_ALWAYS();
      }
   }

   _mediaplayerclienthandler = OSAL_NEW fc_bluetooth_tclClientHandler_MediaPlayer(this);
   if (NULL == _mediaplayerclienthandler)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

   _phoneclienthandler = OSAL_NEW fc_bluetooth_tclClientHandler_Phone(this);

   if (NULL == _phoneclienthandler)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

   _spmcoreclienthandler  = OSAL_NEW fc_bluetooth_tclClientHandler_SpmCore(this);
   if (NULL == _spmcoreclienthandler)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

   _audiorouting = OSAL_NEW FC_Bluetooth_tclAudioRouting(this);

   if (NULL == _audiorouting)
   {
      bSuccess = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }

   ETG_TRACE_USR1(("fc_bluetooth_tclApp : bOnInit exited - %10s", bSuccess ? "true": "false"));

    return bSuccess;
}

/**
 * TODO: temporary workaround for NCG3D-14847
 */
tVoid fc_bluetooth_tclApp::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
{
   ETG_TRACE_USR1(("fc_bluetooth_tclApp : vOnNewAppState entered - u32OldAppState:%d u32AppState-%d", u32OldAppState, u32AppState));

   if ( _tclLoadPair.bIfPairIncluded(u32OldAppState, u32AppState) == TRUE)
   {
       vAppStateChanged (u32AppState, 20000);
   }
   else if (_tclSavePair.bIfPairIncluded(u32OldAppState, u32AppState) == TRUE)
   {
       vAppStateChanged (u32AppState, 40000);
   }

   ahl_tclBaseOneThreadApp::vOnNewAppState(u32OldAppState, u32AppState);
}

/**
 * fc_bluetooth_tclApp::vOnApplicationClose()
 */
tVoid fc_bluetooth_tclApp::vOnApplicationClose()
{
   ENTRY

   ETG_TRACE_USR1(("fc_bluetooth_tclApp : vOnApplicationClose entered"));

   _BP_TRY_BEGIN
   {
      if(_audiorouting != NULL)
      {
         OSAL_DELETE _audiorouting;
         _audiorouting = NULL;
      }

      if (_diaglibservice != OSAL_NULL)
      {
         OSAL_DELETE _diaglibservice;
         _diaglibservice = OSAL_NULL;
      }

      if (_diaglibclienthandler != OSAL_NULL)
      {
         OSAL_DELETE _diaglibclienthandler;
         _diaglibclienthandler = OSAL_NULL;
      }

      if (_diaglogclienthandler != OSAL_NULL)
      {
         OSAL_DELETE _diaglogclienthandler;
         _diaglogclienthandler = OSAL_NULL;
      }

      if (_mediaplayerclienthandler != NULL)
      {
         OSAL_DELETE _mediaplayerclienthandler;
         _mediaplayerclienthandler = NULL;
      }

      if (_spmcoreclienthandler != NULL)
      {
         OSAL_DELETE _spmcoreclienthandler;
         _spmcoreclienthandler = NULL;
      }

      if (_defsetclienthandler != NULL)
      {
         OSAL_DELETE _defsetclienthandler;
         _defsetclienthandler = NULL;
      }

      BmCoreFactory::getInstance().destroyBmCoreRequestIfInstance();
      _bmCoreRequestIf = NULL;

      if (_testCommand != NULL)
      {
         // deregistration of TTFis channel shall be done after destroying BM core instance
         _testCommand->destroy();
         OSAL_DELETE _testCommand;
         _testCommand = NULL;
      }

      if (_bluetoothCCAService != NULL)
      {
         OSAL_DELETE _bluetoothCCAService;
         _bluetoothCCAService = NULL;
      }

      if (_phoneclienthandler != NULL)
      {
         OSAL_DELETE _phoneclienthandler;
         _phoneclienthandler = NULL;
      }

      if (_outputWrapper != NULL)
      {
         OSAL_DELETE _outputWrapper;
         _outputWrapper = NULL;
      }
   }
   _BP_CATCH_ALL
   {}
   _BP_CATCH_END

    ahl_tclBaseOneThreadApp::vOnApplicationClose();
    return;
}

/**
 * fc_bluetooth_tclApp::vOnLoadSettings()
 */
tVoid fc_bluetooth_tclApp::vOnLoadSettings()
{
    ENTRY

    ETG_TRACE_USR1(("fc_bluetooth_tclApp : vOnLoadSettings entered"));

    BmResult result = BM_RESULT_ERR_GENERAL;

    if(_bmCoreRequestIf)
    {
       result = _bmCoreRequestIf->stateChangeNormal();
    }

    if (BM_RESULT_OK != result)
    {
       ETG_TRACE_ERR(("fc_bluetooth_tclApp: stateChangeNormal Failure"));
       //TODO BM Database creation needs to be verified.
       FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
       if (NULL != _spmcoreclienthandler)
       {
          _spmcoreclienthandler->vGetBluetoothState();
       }

       ETG_TRACE_USR1(("fc_bluetooth_tclApp: stateChangeNormal Success"));
       if(_bluetoothCCAService)
       {
          _bluetoothCCAService->updateRingtoneValues(FALSE);
       }
    }

    ETG_TRACE_USR1(("fc_bluetooth_tclApp : vOnLoadSettings exited"));

    return;
}

/**
 * fc_bluetooth_tclApp::vOnSaveSettings()
 */
tVoid fc_bluetooth_tclApp::vOnSaveSettings()
{
    ENTRY

    ETG_TRACE_USR1(("fc_bluetooth_tclApp : vOnSaveSettings entered"));

    BmResult result = BM_RESULT_ERR_GENERAL;

    if(_bmCoreRequestIf)
    {
       result = _bmCoreRequestIf->stateChangeOff();
    }

    if (BM_RESULT_OK != result)
    {
       FATAL_M_ASSERT_ALWAYS();
    }
    else
    {
       ETG_TRACE_USR1(("fc_bluetooth_tclApp: stateChangeOff Success"));
    }

    ETG_TRACE_USR1(("fc_bluetooth_tclApp : vOnSaveSettings exited"));

    return;
}

/**
 * fc_bluetooth_tclApp::vOnTimer()
 */
tVoid fc_bluetooth_tclApp::vOnTimer(tU16 u16TimerId)
{
    ETG_TRACE_USR1(("fc_bluetooth_tclApp::vOnTimer ID :%d:", u16TimerId));

    switch (u16TimerId)
    {
       case ARL_RESPONSE_TIMER_ID:
       {
          ETG_TRACE_USR4(("vOnTimer: ARL_RESPONSE_TIMER_ID"));

          if(NULL != _audiorouting)
          {
             _audiorouting->vARLResponseTimerCb();
          }
       }
       break;
       default:
       {
          ETG_TRACE_USR4(("Invalid Timer ID :%d:", u16TimerId));
       }
       break;
    }

    return;
}

/**
 * FC_Bluetooth_tclCCAService::vOnLoopback()
 */
tVoid fc_bluetooth_tclApp::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData *poMessage)
{
    ENTRY

    switch(u16ServiceID)
    {
      case CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS:
      {
        if(NULL != _bluetoothCCAService)
        {
          _bluetoothCCAService->vOnLoopbackService(poMessage);
        }
        else
        {
          NORMAL_M_ASSERT_ALWAYS();
        }
      }
      break;

      default:
      {
        ETG_TRACE_USR2(("vOnLoopback(). Unknown ServiceID %u.", u16ServiceID));
      }
    }
    return;
}

#ifdef VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS

#define EVENT_SHUTDOWN_NAME "SHUTDOWN_FC_BLUETOOTH"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[])
{
   (tVoid) aPar ;
   (tVoid) cPar ;
   OSAL_tEventHandle  hEvShutdown = 0;
   OSAL_tEventMask    hEvRequest  = 0x00000001;

   et_vTraceOpen();
   et_vTraceBuffer(TR_TTFIS_SYSMANAGER, TR_LEVEL_DATA, 9, "START BLUETOOTH ");
   scd_init();

#ifdef VARIANT_S_FTR_ENABLE_LOAD_REGISTRY
   OSAL_tIODescriptor  regHandle;
   if((regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY,OSAL_EN_READWRITE)) != OSAL_ERROR )
   {
      if((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG,(tS32)"/dev/root/opt/bosch/base/registry/fc_bluetooth.reg")) == OSAL_OK)
      {
         ETG_TRACE_FATAL(("REGISTRY loaded '/opt/bosch/base/registry/fc_bluetooth.reg'!"));
      }
      else
      {
         ETG_TRACE_FATAL(("!!!!!!!!!! FAILED to load REGISTRY '/opt/bosch/base/registry/fc_bluetooth.reg'!"));
      }
   }
   OSAL_s32IOClose(regHandle);
#endif

   if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
   {
      ETG_TRACE_FATAL(("fc_bluetooth_tclApp: Creation of SPM shutdown event failed!!! ErrorCode: %x", OSAL_u32ErrorCode()));
      ETG_TRACE_FATAL(("fc_bluetooth_tclApp: OSAL_E_NOERROR: %x", OSAL_E_NOERROR));
      ETG_TRACE_FATAL(("fc_bluetooth_tclApp: OSAL ErrorCode: %x", OSAL_u32ErrorCode()));
      NORMAL_M_ASSERT_ALWAYS();
   }

   fc_bluetooth_tclApp *poBluetoothApp = new fc_bluetooth_tclApp;

   if (poBluetoothApp != NULL)
   {
      if (!poBluetoothApp->bInitInstance(0, CCA_C_U16_APP_BLUETOOTH))
      {
         ETG_TRACE_ERR(("poFcbluetoothApp->bInitInstance() failed!!!"));
      } 
      else 
      {
         ETG_TRACE_USR4(("poFcbluetoothApp->bInitInstance() success!"));
      }
   }

   // Wait for Shutdown-Signal
   (void) OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR, OSAL_C_TIMEOUT_FOREVER, &hEvRequest);
   if (poBluetoothApp != NULL)
   {
      poBluetoothApp->vDeinitInstance();
      delete poBluetoothApp;
   }

   OSAL_s32EventClose(hEvShutdown);
   OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME);
   et_vTraceClose();
   return OSAL_OK;
}

#endif // VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS

/** @} */
