/**
 * @file FC_Bluetooth_clienthandler_MediaPlayer.cpp
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief ClientHandler for the service of the Mediaplayer
 *
 * @{
 */
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

//Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"
#include "conn_most_fi_if.h"

#include "FC_Bluetooth_main.h"
#include "FC_Bluetooth_clienthandler_MediaPlayer.h"
#include "FC_Bluetooth_CCAService.h"
#include "IBmCoreRequestIf.h"
#include "FunctionTracer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FC_Bluetooth_clienthandler_MediaPlayer.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
fc_bluetooth_tclClientHandler_MediaPlayer* fc_bluetooth_tclClientHandler_MediaPlayer::_mediaplayerinstance =
      OSAL_NULL;

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/
BEGIN_MSG_MAP(fc_bluetooth_tclClientHandler_MediaPlayer, ahl_tclBaseWork)

ON_MESSAGE_SVCDATA( MPLAY_APPCONTROLFI_C_U16_DIPODEVICECONNECTIONS,
      AMT_C_U8_CCAMSG_OPCODE_STATUS ,
      onDIPODeviceConnectionsStatus )

END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

fc_bluetooth_tcl_DIPODeviceConnections& fc_bluetooth_tcl_DIPODeviceConnections::
        operator=(mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus &coRef)
{
   ENTRY

   if (this == &coRef)
      return *this;

   oDeviceInfo.oItems.clear();

   mplay_fi_tcl_DiPODeviceInfoItem empty;

   for (tU32 u32Index = FC_BLUETOOTH_CCASERVICE_ZERO; u32Index < coRef.oDeviceInfo.oItems.size(); u32Index++)
   {
      oDeviceInfo.oItems.push_back(empty);
      mplay_fi_tcl_DiPODeviceInfoItem& diPODeviceInfoItem = oDeviceInfo.oItems.back();

      diPODeviceInfoItem.sDeviceName.bSet(
            coRef.oDeviceInfo.oItems[u32Index].sDeviceName.szValue, mplay_fi_tclString::FI_EN_UTF8);
      diPODeviceInfoItem.sDeviceSerialNumber.bSet(
            coRef.oDeviceInfo.oItems[u32Index].sDeviceSerialNumber.szValue, mplay_fi_tclString::FI_EN_UTF8);

      diPODeviceInfoItem.e8DeviceType.enType = coRef.oDeviceInfo.oItems[u32Index].e8DeviceType.enType;
      diPODeviceInfoItem.bDeviceConnected = coRef.oDeviceInfo.oItems[u32Index].bDeviceConnected;
      diPODeviceInfoItem.bDeviceActiveSource = coRef.oDeviceInfo.oItems[u32Index].bDeviceActiveSource;
      diPODeviceInfoItem.e8ConnectionType.enType = coRef.oDeviceInfo.oItems[u32Index].e8ConnectionType.enType;
      diPODeviceInfoItem.e8DiPOCaps.enType = coRef.oDeviceInfo.oItems[u32Index].e8DiPOCaps.enType;
   }

   ETG_TRACE_USR4((" COPYING data _FINISHED_"));
   return *this;
}

/*******************************************************************************
 *
 * FUNCTION    :  fc_bluetooth_tclClientHandler_MediaPlayer::
 *                fc_bluetooth_tclClientHandler_MediaPlayer(fc_bluetooth_tclApp* poMainAppl)
 *
 * DESCRIPTION :  Constructor.
 *
 *                Create an object of the base class
 *                ahl_tclBaseOneThreadClientHandler with a pointer to this
 *                application, the to be used service identifier and the service
 *                version as parameters.
 *
 * PARAMETER   :  [IN] poMainAppl = Pointer to the object of this application.
 *
 * RETURNVALUE :  None.
 *
 *******************************************************************************/
fc_bluetooth_tclClientHandler_MediaPlayer::fc_bluetooth_tclClientHandler_MediaPlayer(fc_bluetooth_tclApp* poMainAppl) :
      ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer          */poMainAppl,
      /* ID of used Service           */CCA_C_U16_SRV_IPOD_APP_CONTROL,
      /* MajorVersion of used Service */MPLAY_APPCONTROLFI_C_U16_SERVICE_MAJORVERSION,
      /* MinorVersion of used Service */MPLAY_APPCONTROLFI_C_U16_SERVICE_MINORVERSION,
      /* App ID */CCA_C_U16_APP_MEDIAPLAYER)
{
   ENTRY

   _mediaplayerinstance = this;
   _bluetoothApp = poMainAppl;
   _u8CounterIphoneConnected = FC_BLUETOOTH_CCASERVICE_ZERO;

   //Registering properties
   vAddAutoRegisterForProperty(MPLAY_APPCONTROLFI_C_U16_DIPODEVICECONNECTIONS);
}

/*******************************************************************************
 *
 * FUNCTION    :  fc_bluetooth_tclClientHandler_MediaPlayer::
 *                ~fc_bluetooth_tclClientHandler_MediaPlayer(tVoid)
 *
 * DESCRIPTION : Destructor.
 *
 * PARAMETER   : None.
 *
 * RETURNVALUE : None.
 *
 *******************************************************************************/
fc_bluetooth_tclClientHandler_MediaPlayer::~fc_bluetooth_tclClientHandler_MediaPlayer(tVoid)
{
   ENTRY

   _bluetoothApp = OSAL_NULL;
   _mediaplayerinstance = OSAL_NULL;
   _DIPODeviceConnectionStatus.vDestroy();
}

/*******************************************************************************
 *
 * FUNCTION    :  tVoid fc_bluetooth_tclClientHandler_MediaPlayer::
 *							   vOnServiceAvailable()
 *
 * DESCRIPTION :  This function is called by the CCA framework when the service
 *                this client-handler has registered for has become available.
 *
 * PARAMETER   :  None.
 *
 * RETURNVALUE :  None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
 *******************************************************************************/
tVoid fc_bluetooth_tclClientHandler_MediaPlayer::vOnServiceAvailable()
{
   ENTRY

   ETG_TRACE_USR2((" vOnServiceAvailable() entered. AppID = %u.", u16GetServerAppID()));
}

/*******************************************************************************
 *
 * FUNCTION    :  tVoid fc_bluetooth_tclClientHandler_MediaPlayer::
 *                vOnServiceUnavailable()
 *
 * DESCRIPTION :  This function is called by the CCA framework when the service
 *                this client-handler has registered for has become unavailable.
 *
 * PARAMETER   :  None.
 *
 * RETURNVALUE :  None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
 *******************************************************************************/
tVoid fc_bluetooth_tclClientHandler_MediaPlayer::vOnServiceUnavailable()
{
   ENTRY

   ETG_TRACE_USR2((" vOnServiceAvailable() entered. AppID = %u.", u16GetServerAppID()));
}

/*******************************************************************************
 *
 * FUNCTION    : poGetInstance()
 *
 * DESCRIPTION : To get instance of mediaPlayer Client Handler
 *
 * PARAMETER   :
 *
 * RETURNVALUE : - mediaPlayer Client Handler Instance
 *
 *******************************************************************************/
fc_bluetooth_tclClientHandler_MediaPlayer* fc_bluetooth_tclClientHandler_MediaPlayer::poGetInstance()
{
   ENTRY
   return _mediaplayerinstance;
}
/*******************************************************************************
 *
 *  FUNCTION   :  onDIPODeviceConnectionsStatus
 *
 * DESCRIPTION :  Media player Device Connection Status handler
 *
 * PARAMETER   : [IN] poMessage
 *
 * RETURNVALUE : None.
 *
 ********************************************************************************/
tVoid fc_bluetooth_tclClientHandler_MediaPlayer::onDIPODeviceConnectionsStatus(amt_tclServiceData* poMessage)
{
   ENTRY

   _dIPOConnectionChangedLock.lock();

   mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus DIPODeviceConnectionStatus;
   tU8 u8CounterConnectedIPhoneCurrent = FC_BLUETOOTH_CCASERVICE_ZERO;

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   // Unmarshal the FI visitor message to the given FI data object.
   // The parameters are copied individually from shared memory to the FI data
   // object.
   if (oVisitorMsg.s32GetData(DIPODeviceConnectionStatus, FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION) != OSAL_ERROR)
   {
      _DIPODeviceConnectionStatus = DIPODeviceConnectionStatus;

      ETG_TRACE_USR1(("DiPO :: DeviceConnection_Status::TotalDeviceInDeviceList :%u", _DIPODeviceConnectionStatus.oDeviceInfo.oItems.size()));

      for (tU16 u16Index = FC_BLUETOOTH_CCASERVICE_ZERO; u16Index < _DIPODeviceConnectionStatus.oDeviceInfo.oItems.size(); u16Index++)
      {
         ETG_TRACE_USR1(("	  onDIPODeviceConnectionsStatus::sDeviceName[%d]		  :%s", u16Index, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].sDeviceName.szValue));

         ETG_TRACE_USR1(("	  onDIPODeviceConnectionsStatus::e8DeviceType[%d]		  :%d", u16Index, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].e8DeviceType.enType));

         ETG_TRACE_USR1(("	  onDIPODeviceConnectionsStatus::sDeviceSerialNumber[%d] :%s", u16Index, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].sDeviceSerialNumber.szValue));

         ETG_TRACE_USR1(("	  onDIPODeviceConnectionsStatus::bDeviceConnected[%d]	  :%d", u16Index, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].bDeviceConnected));

         ETG_TRACE_USR1(("	  onDIPODeviceConnectionsStatus::bDeviceActiveSource[%d] :%d", u16Index, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].bDeviceActiveSource));

         ETG_TRACE_USR1(("   onDIPODeviceConnectionsStatus::e8DiPOCaps[%d] :%d", u16Index, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].e8DiPOCaps.enType));

         mplay_fi_tcl_e8_DiPODeviceType::tenType enDeviceTypeTemp = _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].e8DeviceType.enType;
         mplay_fi_tcl_e8_DiPOCaps::tenType enDipoCaps = _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].e8DiPOCaps.enType;

         if (((mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPHONE == enDeviceTypeTemp) || (mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPOD == enDeviceTypeTemp)) &&
               (_DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].bDeviceConnected == TRUE))
         {
            u8CounterConnectedIPhoneCurrent++;
         }
         else
         {
            if (((mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPHONE == enDeviceTypeTemp) || (mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPOD == enDeviceTypeTemp)) &&
                  (_DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].bDeviceConnected == FALSE) && (mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_NATIVE_TRANSPORT == enDipoCaps))
            {
               ETG_TRACE_USR2(("_IPHONE is Connected via mySPIN - %s", _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].sDeviceName.szValue));

               if(_u8CounterIphoneConnected != FC_BLUETOOTH_CCASERVICE_ZERO)
               {
                  u8CounterConnectedIPhoneCurrent++;
               }
            }
         }
      }

      ETG_TRACE_USR2((" Number of _IPHONE Connected to mediaPlayer: NEW :%u OLD : %u", u8CounterConnectedIPhoneCurrent, _u8CounterIphoneConnected));

      if (_u8CounterIphoneConnected != u8CounterConnectedIPhoneCurrent)
      {
         _u8CounterIphoneConnected = u8CounterConnectedIPhoneCurrent;

         bExecuteAVPConnectDisconnectOnDeviceListUpdate();
      }
   }

   DIPODeviceConnectionStatus.vDestroy();

   _dIPOConnectionChangedLock.unlock();
}
/*******************************************************************************
 *
 * FUNCTION    : bCheckDeviceIsIphone_ConnectedToMediaPlayer()
 *
 * DESCRIPTION :
 *
 * PARAMETER   : None.
 *
 * RETURNVALUE : None.
 *
 ********************************************************************************/
tBool fc_bluetooth_tclClientHandler_MediaPlayer::bCheckDeviceIsIphone_ConnectedToMediaPlayer(DeviceId deviceHandle, std::string szDeviceName)
{
   ENTRY

   _dIPOConnectionChangedLock.lock();

   ETG_TRACE_USR2(("szDeviceName : %s",szDeviceName.c_str()));

   tBool bDeviceConnectedToMediaPlayer = FALSE;

   //Go through the mediaPlayer Device List
   //Check queryed Device Name is IPHONE and connected to Mediaplayer

   for (tU16 u16Index = FC_BLUETOOTH_CCASERVICE_ZERO; u16Index < _DIPODeviceConnectionStatus.oDeviceInfo.oItems.size(); u16Index++)
   {
      mplay_fi_tcl_e8_DiPODeviceType::tenType enDeviceTypeTemp = _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].e8DeviceType.enType;

      ETG_TRACE_USR1(("     bCheckDeviceIsIphone_ConnectedToMediaPlayer::sDeviceName[%d]         :%s", u16Index, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].sDeviceName.szValue));

      if (0 == s32StringCompare(szDeviceName.c_str(), _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].sDeviceName.szValue))
      {
         if (((mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPHONE == enDeviceTypeTemp) || (mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPOD == enDeviceTypeTemp)) &&
               (mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_USB == _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].e8ConnectionType.enType))
         {
            if((TRUE == _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].bDeviceConnected) || ((FALSE == _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].bDeviceConnected) &&
                  (mplay_fi_tcl_e8_DiPOCaps::FI_EN_E8DIPO_CAP_NATIVE_TRANSPORT == _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16Index].e8DiPOCaps.enType)))
            {
               ETG_TRACE_USR4((" bCheckDeviceIsIphone:FOUND the Device Connected with MediaPlayer and is IPHONE type"));

               vDisconnectAndBlockAVPProfile(deviceHandle);

               bDeviceConnectedToMediaPlayer = true;
            }
         }

         if(TRUE == bDeviceConnectedToMediaPlayer)
            break;
      }
   }

   _dIPOConnectionChangedLock.unlock();

   return bDeviceConnectedToMediaPlayer;
}

/*******************************************************************************
 *
 * FUNCTION    : bExecuteAVPConnectDisconnectOnDeviceListUpdate()
 *
 * DESCRIPTION :
 *
 * PARAMETER   : None.
 *
 * RETURNVALUE : None.
 *
 ********************************************************************************/
tBool fc_bluetooth_tclClientHandler_MediaPlayer::bExecuteAVPConnectDisconnectOnDeviceListUpdate()
{
   ENTRY
   tBool bExecuting = TRUE;

   //Checking, from Bluetooth connection Device List to MediaPlayer Device List
   tBool bMediaplayerDeviceConnected = FALSE;
   tBool bAVPConnectionStatusBT = FALSE; //Not Connected
   tU16 u16IndexBT = FC_BLUETOOTH_CCASERVICE_ZERO;
   mplay_fi_tcl_e8_DiPOConnectionType::tenType e8_connectiontype = mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_UNKNOWN;

   PairedDeviceList pairedDeviceList;
   DeviceConnectionStatusList deviceConnectionStatusList;
   enBlockInfo blockAVPStatus;
   DeviceConnectionInfoList::iterator connListIt;

   FC_Bluetooth_tclCCAService* poCCAService = FC_Bluetooth_tclCCAService::poGetInstance();
   poCCAService->vGetPairedDeviceList(pairedDeviceList);
   poCCAService->vGetDeviceConnectionStatusList(deviceConnectionStatusList);

   for (std::list<DeviceBaseInfo>::iterator it = pairedDeviceList._deviceBaseInfoList.begin();
         it != pairedDeviceList._deviceBaseInfoList.end(); it++)
   {
      bAVPConnectionStatusBT = FALSE; //Not Connected

      u16IndexBT++;

      if (it->_connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
      {
         connListIt = std::find_if(deviceConnectionStatusList._deviceConnectionInfoList.begin(),
               deviceConnectionStatusList._deviceConnectionInfoList.end(),
               MeetsDeviceHandle<DeviceConnectionInfo>(it->_deviceHandle));

         if (connListIt != deviceConnectionStatusList._deviceConnectionInfoList.end())
         {
            for (ProtocolConnectionInfoMap::iterator ItProConInfoMap = connListIt->_protocolConnectionInfo.begin();
                  ItProConInfoMap != connListIt->_protocolConnectionInfo.end(); ItProConInfoMap++)
            {
               ProtocolId protocolId = ItProConInfoMap->first;
               ProtocolConnectionInfo protocolconnectioninfo = ItProConInfoMap->second;

               if (protocolId == BM_PROTOCOL_ID_AVP)
               {
                  if (protocolconnectioninfo._connectionStatus == BM_CONNECTION_STATUS_CONNECTED)
                  {
                     bAVPConnectionStatusBT = TRUE;
                  }
                  break;
               }
            }
         }

         ETG_TRACE_USR2((" DEVICE CONNECTED AT :  Index %d with AVP_status %d for DeviceName : %s", u16IndexBT, bAVPConnectionStatusBT, it->_bdName.c_str()));

         for (tU16 u16IndexMedia = 0; u16IndexMedia < _DIPODeviceConnectionStatus.oDeviceInfo.oItems.size(); u16IndexMedia++)
         {
            if ((mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPHONE == _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].e8DeviceType.enType) || (mplay_fi_tcl_e8_DiPODeviceType::FI_EN_E8DTY_IPOD == _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].e8DeviceType.enType))
            {
               ETG_TRACE_USR2((" MediaPlayer Device List : IPhone Device found with DeviceName[%d] :%s", u16IndexMedia, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].sDeviceName.szValue));

               if (0 == s32StringCompare(_DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].sDeviceName.szValue, it->_bdName.c_str()))
               {
                  ETG_TRACE_USR2(("bAVPConnectionStatusBT : %d   bDeviceConnectedMedia : %d", bAVPConnectionStatusBT, _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].bDeviceConnected));

                  ETG_TRACE_USR2(("Media player connection type: %d", _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].e8ConnectionType.enType));

                  e8_connectiontype = _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].e8ConnectionType.enType;

                  if (TRUE == _DIPODeviceConnectionStatus.oDeviceInfo.oItems[u16IndexMedia].bDeviceConnected)
                  {
                     bMediaplayerDeviceConnected = TRUE;
                  }
                  else
                  {
                     // set the bMediaplayerDeviceConnected flag as false if the device is not connected in Media
                     bMediaplayerDeviceConnected = FALSE;
                  }

                  if (FALSE == bAVPConnectionStatusBT && FALSE == bMediaplayerDeviceConnected)
                  {
                     if ( mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_BLUETOOTH != e8_connectiontype )
                     {
                        ETG_TRACE_USR4((" bExecuteAVPConnectDisconnectOnDeviceListUpdate : "
                              "Sending Unblock Request to BMCore "));

                        poCCAService->getBlockInfoStauts(it->_deviceHandle, blockAVPStatus);

                        vUnblockAndConnectAVPProfile(it->_deviceHandle, blockAVPStatus);
                     }
                  }
                  /*
                   * IPHONE is not connected to Mediaplayer and AVP Profile is  connected.
                   * send AVP Disconnect Request
                   */
                  else if ((TRUE == bMediaplayerDeviceConnected) && (TRUE == bAVPConnectionStatusBT))
                  {
                     if ((mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_BLUETOOTH == e8_connectiontype ))
                     {
                        ETG_TRACE_USR4((" IAP Connected via Bluetooth - Don't disconnect AVP"));
                     }
                     else if (mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_USB == e8_connectiontype)
                     {
                        ETG_TRACE_USR4((" IAP Connected via USB - Disconnect AVP"));

                        ETG_TRACE_USR4((" bExecuteAVPConnectDisconnectOnDeviceListUpdate : "
                              "Sending Block Request to BMCore "));

                        poCCAService->setBlockInfoStauts(it->_deviceHandle, AVP_DISCONNECT_BLOCKED);

                        vDisconnectAndBlockAVPProfile(it->_deviceHandle);
                     }
                  }
                  else if ((TRUE == bMediaplayerDeviceConnected) && (FALSE == bAVPConnectionStatusBT))
                  {
                     if ((e8_connectiontype != mplay_fi_tcl_e8_DiPOConnectionType::FI_EN_E8DCT_USB ))
                     {
                        ETG_TRACE_USR4((" IAP Connected via Bluetooth - reconnect AVP "));

                        ETG_TRACE_USR4((" bExecuteAVPConnectDisconnectOnDeviceListUpdate : "
                              "Sending Unblock Request to BMCore"));

                        poCCAService->getBlockInfoStauts(it->_deviceHandle, blockAVPStatus);

                        vUnblockAndConnectAVPProfile(it->_deviceHandle, blockAVPStatus);
                     }
                     else
                     {
                        ETG_TRACE_USR4((" IAP is connected via USB "));

                        poCCAService->getBlockInfoStauts(it->_deviceHandle, blockAVPStatus);

                        if(blockAVPStatus == AVP_UNBLOCKED)
                        {
                           ETG_TRACE_USR4((" bExecuteAVPConnectDisconnectOnDeviceListUpdate : "
                                 "Sending Block Request to BMCore "));

                           poCCAService->setBlockInfoStauts(it->_deviceHandle, AVP_BLOCKED);

                           vDisconnectAndBlockAVPProfile(it->_deviceHandle);
                        }
                     }
                  }
                  else
                  {
                     ETG_TRACE_USR4((" No device is connected at BT index = %d bMediaplayerDeviceConnected = %d Connection Type = %d", u16IndexBT, bMediaplayerDeviceConnected, e8_connectiontype));
                  }
               }
            }
            else
            {
               ETG_TRACE_USR2((" The device is not a type of IPHONE or IPOD from the index %d", u16IndexMedia));
            }

            ETG_TRACE_USR2((" Check for Next device"));
         }
      }
      else
      {
         poCCAService->getBlockInfoStauts(it->_deviceHandle, blockAVPStatus);

         if(blockAVPStatus != AVP_UNBLOCKED)
         {
            ETG_TRACE_USR4((" bExecuteAVPConnectDisconnectOnDeviceListUpdate : "
            "Sending Connect Request to AVPConnectDisconnectSM "));

            vUnblockAndConnectAVPProfile(it->_deviceHandle, blockAVPStatus);
         }
         else
         {
            if (bCheckDeviceIsIphone_ConnectedToMediaPlayer(it->_deviceHandle, it->_bdName) == true)
            {
               poCCAService->setBlockInfoStauts(it->_deviceHandle, AVP_BLOCKED);
            }
         }
      }
   }

   return bExecuting;
}

tVoid fc_bluetooth_tclClientHandler_MediaPlayer::vDisconnectAndBlockAVPProfile(DeviceId deviceHandle)
{
   ProtocolList protocolList;
   Protocol protocol;

   ETG_TRACE_USR2((" vDisconnectAndBlockAVPProfile:: devicehandle - %d", deviceHandle));

   protocolList.clear();
   protocol._protocolId = BM_PROTOCOL_ID_AVP;
   protocol._uuid = "";
   protocolList.push_back(protocol);

   if (_bluetoothApp)
   {
      _bluetoothApp->getBmCoreRequestIf().blockProfiles(deviceHandle, protocolList);
   }
}

tVoid fc_bluetooth_tclClientHandler_MediaPlayer::vUnblockAndConnectAVPProfile(DeviceId deviceHandle, enBlockInfo blockInfo)
{
   ProtocolList protocolList;
   Protocol protocol;

   ETG_TRACE_USR2((" vUnblockAndConnectAVPProfile:: devicehandle - %d blockinfo- %u", deviceHandle, ETG_CENUM(enBlockInfo, blockInfo)));

   protocolList.clear();
   protocol._protocolId = BM_PROTOCOL_ID_AVP;
   protocol._uuid = "";
   protocolList.push_back(protocol);

   if(blockInfo != AVP_UNBLOCKED)
   {
      if (_bluetoothApp)
      {
         _bluetoothApp->getBmCoreRequestIf().unblockProfiles(deviceHandle, protocolList);
      }
   }
}
