/**
 * @file       :  fc_bluetooth_tclClientHandler_DefSetHandler.cpp
 * @author     :
 * @copyright  :  (c) 2015 Robert Bosch Car Multimedia GmbH
 * @addtogroup :  FC_Bluetooth
 *
 * @brief      :  Example implementation of a system set listener.
* This handler sets the demodata value used for IncreaseDecrease demo
* back to default on a DefSet request.
* Take this class as a template for your own listener classes and
* adjust the parts marked with
* // +++ comment +++
*
* - ccademo_diaghandler.x              => // +++ Comment +++
* - ccademo_IncreaseDecreaseHandler.x  => // +++ Comment +++
* - Bluetooth_DefSetHandler.x            => // +++ Comment +++
* - ccademo_main.x                     => // +++diaglib+++ comment
* - ccademo_msgtypes.h                 => // +++diaglib+++ comment
 * @{
 */

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
// +++ Specify what part of diaglib you need in this file +++

#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"  

/* Needed for Trace */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "FC_Bluetooth_main.h"
#include "FC_Bluetooth_clienthandler_DefSetHandler.h"
#include "FC_Bluetooth_CCAService.h"
#include "FunctionTracer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FC_Bluetooth_clienthandler_DefSetHandler.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APPLICATION
#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

fc_bluetooth_tclClientHandler_DefSetHandler::fc_bluetooth_tclClientHandler_DefSetHandler(
      diaglib::tclServiceDiaglib* pDiaglibService) : _diaglibservice(pDiaglibService)
{
   ENTRY

   if (_diaglibservice != OSAL_NULL)
   {
      ETG_TRACE_USR4(("Phonebook_DefSetHandler => vRegisterListener(SYSSETID_BLUETOOTH) "));
      _diaglibservice->poGetSysSet()->vRegisterListener(SYSSETID_BLUETOOTH, this);

      ETG_TRACE_USR4(("Phonebook_DefSetHandler => vRegisterListener(SYSSETID_ALL_COMP) "));
      _diaglibservice->poGetSysSet()->vRegisterListener(SYSSETID_ALL_COMP, this);

      ETG_TRACE_USR4(("Phonebook_DefSetHandler => vRegisterListener(SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA) "));
      _diaglibservice->poGetSysSet()->vRegisterListener(SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA, this);

      ETG_TRACE_USR4(("Phonebook_DefSetHandler => vRegisterListener(SYSSETID_GROUP_HMI_RESTORE_RADIO_SETTING) "));
      _diaglibservice->poGetSysSet()->vRegisterListener(SYSSETID_GROUP_HMI_RESTORE_RADIO_SETTING, this);
   }
   else
   {

      ETG_TRACE_USR4(("_diaglibservice is NULL"));
   }
}

fc_bluetooth_tclClientHandler_DefSetHandler::~fc_bluetooth_tclClientHandler_DefSetHandler()
{
   ENTRY
   _diaglibservice = OSAL_NULL;
}

tU32 fc_bluetooth_tclClientHandler_DefSetHandler::vOnSystemSet(tU32 u32SystemSetID,
      diaglib::tenSystemSetType u32SystemSetType, diaglib::tContext MsgContext)
{
   ENTRY

   ETG_TRACE_USR2((" vOnSystemSet: u32SystemSetID : %d :: u32SystemSetType : %d",\
         u32SystemSetID, u32SystemSetType));

   tU32 u32Return = diaglib::U32_DIAGLIB_RETURN_OK;
   tS32 s32RetValService = FC_BLUETOOTH_CLEAR_PRIVATEDATA_SUCCESS;
   diaglib::tclParameterVector oTmpVec;
   diaglib::tenSystemSetResult oSysSetResult = diaglib::EN_SYSTEMSET_OK; // default response succefully

   // +++ Set values back to default, then send positive response +++
   switch (u32SystemSetID)
   {
      case SYSSETID_ALL_COMP:
      {
         ETG_TRACE_USR4(("vOnSystemSet => SYSSETID_ALL_COMP"));
         switch (u32SystemSetType)
         {
            case diaglib::EN_TYPE_DEFAULT_TEF:
            case diaglib::EN_TYPE_DEFAULT_CUSTOMER:
            case diaglib::EN_TYPE_DEFAULT_HMI:
            {
               ETG_TRACE_USR4(("vOnSystemSet => EN_TYPE_DEFAULT_TEF"));

               fc_bluetooth_tclApp* poMainApp = fc_bluetooth_tclApp::poGetInstance();
               if (poMainApp)
               {
                  FC_Bluetooth_tclCCAService* poCCAService = FC_Bluetooth_tclCCAService::poGetInstance();
                  if (poCCAService)
                  {

                     ETG_TRACE_USR4(("calling vHandle_ClearAllPrivateData and Radio Settings"));
                     poCCAService->restoreRadioSettings();
                     s32RetValService = poCCAService->clearAllPrivateData();
                  }
               }
               break;
            } // case EN_TYPE_DEFAULT_TEF:

            case diaglib::EN_TYPE_CODING: // Customer EOL
            {
               ETG_TRACE_USR4(("vOnSystemSet => EN_TYPE_CODING"));
               break;
            } // case EN_TYPE_CODING:

            default:
            {
               ETG_TRACE_ERR(("!!! vOnSystemSet => ERROR: not supportet Systemset request"));
               oSysSetResult = diaglib::EN_SYSTEMSET_OK;

               diaglib::trParameter paramError;
               paramError.enType = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
               paramError.u8Value = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
               oTmpVec.push_back(paramError);
               break;
            } // default:
         } // switch(u32SystemSetType)
         break;
      } // case SYSSETID_ALL_COMP:

      case SYSSETID_GROUP_HMI_RESTORE_RADIO_SETTING:
      {
         ETG_TRACE_USR4(("vOnSystemSet => SYSSETID_GROUP_HMI_RESTORE_RADIO_SETTING"));

         fc_bluetooth_tclApp* poMainApp = fc_bluetooth_tclApp::poGetInstance();
         if (poMainApp)
         {
            FC_Bluetooth_tclCCAService* poCCAService = FC_Bluetooth_tclCCAService::poGetInstance();
            if (poCCAService)
            {

               ETG_TRACE_USR4(("calling restoreRadioSettings"));
               poCCAService->restoreRadioSettings();
            }
         }
         break;

      } // case SYSSETID_GROUP_HMI_RESTORE_RADIO_SETTING:

      case SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA:
      {
         ETG_TRACE_USR4(("vOnSystemSet => SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA"));

         fc_bluetooth_tclApp* poMainApp = fc_bluetooth_tclApp::poGetInstance();
         if (poMainApp)
         {
            FC_Bluetooth_tclCCAService* poCCAService = FC_Bluetooth_tclCCAService::poGetInstance();
            if (poCCAService)
            {
               ETG_TRACE_USR4(("calling vHandle_ClearAllPrivateData"));
               s32RetValService = poCCAService->clearAllPrivateData();
            }
         }

         break;
      } // case SYSSETID_GROUP_HMI_CLEAR_ALL_PRIVATE_DATA:

      case SYSSETID_BLUETOOTH: // single Group
      {
         ETG_TRACE_USR4(("vOnSystemSet => SYSSETID_BLUETOOTH"));
         switch (u32SystemSetType)
         {
            case diaglib::EN_TYPE_DEFAULT_TEF:
            case diaglib::EN_TYPE_DEFAULT_CUSTOMER:
            case diaglib::EN_TYPE_DEFAULT_HMI:
            {
               ETG_TRACE_USR4(("vOnSystemSet => SystemSetType:: %u", u32SystemSetType));

               fc_bluetooth_tclApp* poMainApp = fc_bluetooth_tclApp::poGetInstance();
               if (poMainApp)
               {
                  FC_Bluetooth_tclCCAService* poCCAService = FC_Bluetooth_tclCCAService::poGetInstance();
                  if (poCCAService)
                  {

                     ETG_TRACE_USR4(("calling vHandle_ClearAllPrivateData and Radio Settings"));

                     poCCAService->restoreRadioSettings();
                     s32RetValService = poCCAService->clearAllPrivateData();
                  }
               }
               break;
            } // case EN_TYPE_DEFAULT_TEF:,case EN_TYPE_DEFAULT_HMI:

            case diaglib::EN_TYPE_CODING:
            {
               ETG_TRACE_USR4(("vOnSystemSet => EN_TYPE_CODING"));

               break;
            } // case EN_TYPE_CODING:

            default:
            {
               ETG_TRACE_ERR(("!!! vOnSystemSet => ERROR: not supportet Systemset request"));
               oSysSetResult = diaglib::EN_SYSTEMSET_OK;

               diaglib::trParameter paramError;
               paramError.enType = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
               paramError.u8Value = diaglib::EN_ERROR_INCOMPATIBLE_PARAMETER_SIGNATURE;
               oTmpVec.push_back(paramError);
               break;
            } // default:
         } // switch(u32SystemSetType)
         break;
      } // case SYSSETID_BLUETOOTH:

      default:
      {
         ETG_TRACE_ERR(("!!! vOnSystemSet => ERROR: not supportet ID"));
         oSysSetResult = diaglib::EN_SYSTEMSET_OK;

         diaglib::trParameter paramError;
         paramError.enType = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
         paramError.u8Value = diaglib::EN_ERROR_ID_NOT_SUPPORTED;
         oTmpVec.push_back(paramError);
         break;
      } // default:
   } // switch(u32SystemSetID)

   if (FC_BLUETOOTH_CLEAR_PRIVATEDATA_SUCCESS != s32RetValService)
   {
      ETG_TRACE_ERR(("!!! vOnSystemSet =>ERROR: s32RetValService Read SYSSUPPID FAILED "));

      ETG_TRACE_ERR(("Clear Private data fail"));
      oSysSetResult = diaglib::EN_SYSTEMSET_NOT_OK;
      diaglib::trParameter paramError;
      paramError.enType = static_cast<diaglib::tenParameterType>(diaglib::EN_PARAMETER_TYPE_U8ERROR);
      paramError.u8Value = diaglib::EN_ERROR_FATAL_INTERNAL;
      oTmpVec.push_back(paramError);
      u32Return = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
   }

   // send Data back to Server
   if (_diaglibservice != OSAL_NULL)
   {
      if (TRUE == _diaglibservice->poGetSysSet()->bSendSystemSetResult(oSysSetResult, oTmpVec, MsgContext))
      {
         ETG_TRACE_USR4(("vOnSystemSet => bSendSystemSetResult successfull"));
      }
      else
      {
         ETG_TRACE_ERR(("!!! vOnSystemSet => ERROR : bSendSystemSetResult failed"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("!!! vOnSystemSet => ERROR : _diaglibservice == OSAL_NULL"));
   }

   ETG_TRACE_USR2(("<-- vOnSystemSet(%x)", u32Return));
   return u32Return;
}

tU32 fc_bluetooth_tclClientHandler_DefSetHandler::vOnSystemSetFinished(tU32 u32SystemSetID,
      diaglib::tenSystemSetType u32SystemSetType, diaglib::tContext MsgContext)
{
   ENTRY
   // +++ Reallow access to values that needed default setting, then send positive response +++
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType);
   /*
    Respond does not contain any data and is just an acknowledgement.
    */

   if (_diaglibservice != OSAL_NULL)
   {
      if (TRUE == _diaglibservice->poGetSysSet()->bAcknowledgeSystemSetFinished(MsgContext))
      {
         ETG_TRACE_USR4(("vOnSystemSetFinished => bAcknowledgeSystemSetFinished successfull"));
      }
      else
      {
         ETG_TRACE_ERR(("!!! vOnSystemSetFinished => ERROR : bAcknowledgeSystemSetFinished failed"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("!!! vOnSystemSetFinished => ERROR : _diaglibservice == OSAL_NULL"));
   }

   return diaglib::U32_DIAGLIB_RETURN_OK;
}

tU32 fc_bluetooth_tclClientHandler_DefSetHandler::vOnSystemSetPrepare(tU32 u32SystemSetID,
      diaglib::tenSystemSetType u32SystemSetType, diaglib::tContext MsgContext)
{
   ENTRY
   // +++ Stop access to values that need default setting, then send positive response +++
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType);
   //tBool bResponse = TRUE;
   /*
    Response can be one of the following:
    EN_SYSTEMSET_OK            -> Empty error vector

    Actually the diaglib already checks if ID is supported, so we don't need
    to do it here again.
    */
   diaglib::tclParameterVector oTmpVec;

   if (_diaglibservice != OSAL_NULL)
   {
	   //!Fix for CID 20282: Logically dead code (DEADCODE)
      /*if (TRUE == _diaglibservice->poGetSysSet()->bSendSystemSetResult((
            bResponse ? diaglib::EN_SYSTEMSET_OK : diaglib::EN_SYSTEMSET_NOT_OK), oTmpVec, MsgContext))*/
	  if (TRUE == _diaglibservice->poGetSysSet()->bSendSystemSetResult(diaglib::EN_SYSTEMSET_OK, oTmpVec, MsgContext))
      {
         ETG_TRACE_USR4(("vOnSystemSetPrepare => bSendSystemSetResult successfull"));
      }
      else
      {
         ETG_TRACE_ERR(("!!! vOnSystemSetPrepare => ERROR : bSendSystemSetResult failed"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("!!! vOnSystemSetPrepare => ERROR : _diaglibservice == OSAL_NULL"));
   }
   return diaglib::U32_DIAGLIB_RETURN_OK;
}

tU32 fc_bluetooth_tclClientHandler_DefSetHandler::vOnSystemSetCheck(tU32 u32SystemSetID,
      diaglib::tenSystemSetType u32SystemSetType, diaglib::tContext MsgContext)
{
   ENTRY
   // +++ Check if all values are set to default. +++
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType);
   //tBool bResponse = TRUE;
   /*
    Response can be one of the following:
    EN_SYSTEMSET_OK            -> Empty error vector
    EN_SYSTEMSET_NOT_OK        -> List of wrong values

    diaglib already checks if ID is supported, so we don't need
    to do it here again.
    */
   diaglib::tclParameterVector oTmpVec;

   if (_diaglibservice != OSAL_NULL)
   {
	   //!Fix for CID 20281: Logically dead code (DEADCODE)
      /*if (TRUE == _diaglibservice->poGetSysSet()->bSendSystemSetCheckResult((
            bResponse ? diaglib::EN_SYSTEMSET_OK : diaglib::EN_SYSTEMSET_NOT_OK), oTmpVec, MsgContext))*/
      if (TRUE == _diaglibservice->poGetSysSet()->bSendSystemSetCheckResult(diaglib::EN_SYSTEMSET_OK, oTmpVec, MsgContext))
      {
         ETG_TRACE_USR4(("vOnSystemSetCheck => bSendSystemSetCheckResult successfull"));
      }
      else
      {
         ETG_TRACE_ERR(("!!! vOnSystemSetCheck => ERROR : bSendSystemSetCheckResult failed"));
      }
   }
   else
   {
      ETG_TRACE_ERR(("!!! vOnSystemSetCheck => ERROR : _diaglibservice == OSAL_NULL"));
   }
   return diaglib::U32_DIAGLIB_RETURN_OK;
}

