/**
 * @file FC_Bluetooth_Loopback_Controller.cpp
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for FC_Bluetooth_Loopback_Controller
 * @{
 */

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "FC_Bluetooth_main.h"
#include "FC_Bluetooth_CCAService.h"
#include "FC_Bluetooth_Loopback_Controller.h"
#include "FunctionTracer.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APP_LOOPBACK_MSG
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/FC_Bluetooth_Loopback_Controller.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_BLUETOOTH_BM_APP_LOOPBACK_MSG
#endif // VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
/*****************************************************************
 | defines and macros (scope: modul-local)
 |----------------------------------------------------------------*/

//Init static data members
FC_Bluetooth_Loopback_Controller* FC_Bluetooth_Loopback_Controller::_poInstance = NULL;

/*****************************************************************
 | class FC_Bluetooth_DeviceManager
 | implementation
 |----------------------------------------------------------------*/

FC_Bluetooth_Loopback_Controller::FC_Bluetooth_Loopback_Controller() :
      _u32CommandCounter(0)
{
ENTRY}

FC_Bluetooth_Loopback_Controller::~FC_Bluetooth_Loopback_Controller()
{
   ENTRY

   _oDataQueue.clear();

   //Clear static data
   _poInstance = NULL;
}

FC_Bluetooth_Loopback_Controller* FC_Bluetooth_Loopback_Controller::poGetInstance()
{
   ENTRY

   if (_poInstance == NULL)
   {
      _poInstance = OSAL_NEW FC_Bluetooth_Loopback_Controller();
   }

   return _poInstance;
}

tU32 FC_Bluetooth_Loopback_Controller::u32GetNumberOfMessagesInQueue()
{
   ENTRY

   return static_cast<tU32>(_oDataQueue.size());
}

tVoid FC_Bluetooth_Loopback_Controller::vDeleteData(tU32 u32CallbackFuncID, tU32 u32CmdCntr)
{
   ENTRY

   _lock.lock();

   for (size_t i = 0; i < _oDataQueue.size(); i++)
   {
      if ((u32CallbackFuncID == _oDataQueue[i].u32MessageContentId) && (u32CmdCntr == _oDataQueue[i].u32CmdCntr))
      {
         _oDataQueue.erase(_oDataQueue.begin() + i);
         break;
      }
   }

   _lock.unlock();
}

LoopBackMessageData FC_Bluetooth_Loopback_Controller::poGetData(tU32 u32CallbackFuncID, tU32 u32CmdCntr)
{
   ENTRY

   _lock.lock();

   LoopBackMessageData retData;

   for (size_t i = 0; i < _oDataQueue.size(); i++)
   {
      if ((u32CallbackFuncID == _oDataQueue[i].u32MessageContentId) && (u32CmdCntr == _oDataQueue[i].u32CmdCntr))
      {
         retData = poGetQueueElementAt(i);
         break;
      }
   }

   _lock.unlock();

   return retData;
}

void FC_Bluetooth_Loopback_Controller::vPostLoopBackMessageToCCA(LoopBackMessageData oData)
{
   ENTRY

   FC_Bluetooth_tclCCAService* poCCAService = FC_Bluetooth_tclCCAService::poGetInstance();

   if (OSAL_NULL != poCCAService)
   {
      tU16 u16CallbackFuncID = static_cast<tU16>(oData.u32MessageContentId);
      tU32 u32CommandCounterCopy;

      _lock.lock();

      // max allowed value is max of 16 bit unsigned int type
      if(0xFFFF > _u32CommandCounter)
      {
         _u32CommandCounter++;
      }
      else
      {
         _u32CommandCounter = 0;
      }

      oData.u32CmdCntr = _u32CommandCounter;

      _oDataQueue.push_back(oData);

      ETG_TRACE_USR2(("vPostLoopBackMessageToCCA:QueueSize: %u",static_cast<tU32>(_oDataQueue.size())));

      u32CommandCounterCopy = _u32CommandCounter;

      _lock.unlock();

      ETG_TRACE_USR2(("vPostLoopBackMessageToCCA:Cmd %u ", u32CommandCounterCopy ));
      ETG_TRACE_USR2(("vPostLoopBackMessageToCCA:CallbackID %d ",u16CallbackFuncID ));

      poCCAService->vPostLoopBackMessageToCCA(u16CallbackFuncID, u32CommandCounterCopy);
   }
   else
   {
      ETG_TRACE_USR4(("vPostLoopBackMessageToCCA:poCCAService is NULL"));
   }
}

void FC_Bluetooth_Loopback_Controller::vAddToQueue(LoopBackMessageData oData)
{
   ENTRY
   _lock.lock();

   _oDataQueue.push_back(oData);

   _lock.unlock();
}

LoopBackMessageData FC_Bluetooth_Loopback_Controller::poGetQueueElementAt(size_t index)
{
   ENTRY

   LoopBackMessageData retData;

   if (index < _oDataQueue.size())
   {
      retData = _oDataQueue[index];
   }

   return retData;
}
