/**
 * @file FC_Bluetooth_main.h
 * @author 
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for CCABluetoothApplication
 * @{
 */

#ifndef _FC_BLUETOOTH_MAIN_H_
#define _FC_BLUETOOTH_MAIN_H_

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "CCAOutputWrapper.h"

#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

#define FC_BLUETOOTH_CCASERVICE_FI_MAJOR_VERSION  MOST_BTSETFI_C_U16_SERVICE_MAJORVERSION //1
#define FC_BLUETOOTH_CCASERVICE_FI_MINOR_VERSION  MOST_BTSETFI_C_U16_SERVICE_MINORVERSION //8
#define FC_BLUETOOTH_CCASERVICE_FI_PATCH_VERSION  1

// Phone Version
#define FC_BLUETOOTH_SERVICE_TELEPHONE_FI_MAJOR_VERSION  MOST_TELFI_C_U16_SERVICE_MAJORVERSION  //1
#define FC_BLUETOOTH_SERVICE_TELEPHONE_FI_MINOR_VERSION  MOST_TELFI_C_U16_SERVICE_MINORVERSION  //8
#define FC_BLUETOOTH_SERVICE_TELEPHONE_FI_PATCH_VERSION  0

// MediaPlayer Version
#define FC_BLUETOOTH_MEDIAPLAYER_FI_MAJOR_VERSION  MOST_MPLAYFI_C_U16_SERVICE_MAJORVERSION //1
#define FC_BLUETOOTH_MEDIAPLAYER_FI_MINOR_VERSION  MOST_MPLAYFI_C_U16_SERVICE_MINORVERSION //8
#define FC_BLUETOOTH_MEDIAPLAYER_FI_PATCH_VERSION  1

//System State Version
#define FC_BLUETOOTH_SYSTEMSTATE_FI_MAJOR_VERSION  CFC_SPMFI_C_U16_SERVICE_MAJORVERSION //1
#define FC_BLUETOOTH_SYSTEMSTATE_FI_MINOR_VERSION  CFC_SPMFI_C_U16_SERVICE_MINORVERSION //8
#define FC_BLUETOOTH_SYSTEMSTATE_FI_PATCH_VERSION  0

#define BM_APP_OFFSET    0x40
#define BM_APP_RANGE_END 0x47

//  Note: It is possible to add one more trace class,
//        BM_APP_OFFSET range can be 0x40 to 0x47 id these needs to be increased
//        then 0x48 offset(currently it is BMCORE) need to be changed.
enum tenTrcTraceClass_Bluetooth {
  TR_CLASS_FC_BLUETOOTH_BM_APPLICATION = TR_COMP_CONNECTIVITY + BM_APP_OFFSET,
  TR_CLASS_FC_BLUETOOTH_BM_APP_SERVICE = TR_COMP_CONNECTIVITY + BM_APP_OFFSET + 1,
  TR_CLASS_FC_BLUETOOTH_BM_APP_OUTPUTWRAPPER = TR_COMP_CONNECTIVITY + BM_APP_OFFSET + 2,
  TR_CLASS_FC_BLUETOOTH_BM_APP_METHODQUEUE = TR_COMP_CONNECTIVITY + BM_APP_OFFSET + 3,
  TR_CLASS_FC_BLUETOOTH_BM_APP_LOOPBACK_MSG = TR_COMP_CONNECTIVITY + BM_APP_OFFSET + 4,
  TR_CLASS_FC_BLUETOOTH_BM_APP_AUDIOPLAYER = TR_COMP_CONNECTIVITY + BM_APP_OFFSET + 5,
  TR_CLASS_FC_BLUETOOTH_BM_APP_AUDIOROUTING = TR_COMP_CONNECTIVITY + BM_APP_OFFSET + 6
};

#define ARL_RESPONSE_TIMER_ID 1
#define ARL_RESPONSE_MSEC     3500

/** 
 *  class forward declarations. 
 */
class ahl_tclBaseOneThreadApp;
class fc_bluetooth_tclClientHandler_MediaPlayer;
class fc_bluetooth_tclClientHandler_SpmCore;
class fc_bluetooth_tclClientHandler_DefSetHandler;
class fc_bluetooth_tclClientHandler_Phone;
class fc_bluetooth_tclClientHandler_Diaglib;
class fc_bluetooth_tclClientHandler_Diaglog;
class FC_Bluetooth_tclCCAService;
class FC_Bluetooth_tclAudioRouting;
class FC_Bluetooth_TestCommand;

namespace bmcore
{
   class IBmCoreRequestIf;
}

/** 
 * class fc_bluetooth_tclApp:
 * This class implements the CCABluetoothApplication component.
 */
class fc_bluetooth_tclApp : public ahl_tclBaseOneThreadApp
{
   /**
    * static pointer to CCABluetoothApplication instance
    */	
   static fc_bluetooth_tclApp* _bluetoothApp;

public:
   /** 
    * Constructor of the application class
    * Sets the static pointer _bluetoothApp
    * @return  
    */
   fc_bluetooth_tclApp(tVoid);


   /** 
    * Destructor of the application class
    * Sets the static pointer _bluetoothApp to NULL
    * @return  
    */
   virtual ~fc_bluetooth_tclApp(tVoid);


   /**
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_bluetooth_tclApp' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    */
   fc_bluetooth_tclApp& operator= (const fc_bluetooth_tclApp &oFC_Bluetooth);

   /**
    * Copy Constructor, will not be implemented.
    * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
    * 'fc_bluetooth_tclApp' which has no copy constructor.
    * NOTE: This is a technique to disable the copy constructor for this
    * class. So if an attempt for the assignment is made compiler complains.
    */
   fc_bluetooth_tclApp(const fc_bluetooth_tclApp &oFC_Bluetooth);

   // Overriding ahl_tclBaseOneThreadApp methods.

   /**
    * bOnInit():
    * Function is called by framework during startup
    * creates all service and client handler classes
    * gets the instance of the local SPM by calling method LocalSpm::GetInstance(void)  
    * calls method CreateMediaPlayer of LocalSpm
    *
    * @return TRUE if successfull else FALSE
    */
   virtual tBool bOnInit();

   /**
    * TODO: temporary workaround for NCG3D-14847
    */
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);

   /** 
    * vOnApplicationClose():
    * Function is called by framework during shutdown. Not used in GM program
    * deletes all service and client handler classes
    *
    * @return void
    */
   virtual tVoid vOnApplicationClose();

   /** 
    * vOnTimer():
    * Is called by framework when a timer is elapsed
    * 
    * param[in] u16TimerId: Identifier of the expired timer
    *
    * @return void
    */
   virtual tVoid vOnTimer(tU16 u16TimerId);

   /**
    * vOnLoadSettings():
    * Is called by framework when system changes to NORMAL
    * calls StateChangeNormal of local SPM
    *
    * @return void
    */
   virtual tVoid vOnLoadSettings();

   /** 
    * vOnSaveSettings():
    * Is called by framework when system changes to OFF
    * calls StateChangeOff of local SPM
    *
    * @return void
    */
   virtual tVoid vOnSaveSettings();

   /** 
    * vOnLoopback():
    * This function is called by the CCA framework if a message from one if this applications services is received 
    * (so called self or loopback messages). The message is forwarded to the respective service via a call of vOnLoopbackService().
    * 
    * param[in] u16ServiceID: Identifier of the service from where the message was sent
    * param[in] poMessage: Message object
    *
    * @return void
    */
   
   //TODO
   using ahl_tclBaseOneThreadApp::vOnLoopback;

   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   static fc_bluetooth_tclApp* poGetInstance()
   {
      return _bluetoothApp;
   }

   /** 
    * getBluetoothCCAService():
    *
    * @return pointer to BluetoothCCAService
    */
   FC_Bluetooth_tclCCAService &getBluetoothCCAService(void)
   {
      NORMAL_M_ASSERT(NULL != _bluetoothCCAService);
      return *_bluetoothCCAService;
   };

   fc_bluetooth_tclClientHandler_Diaglog &getClientHandlerDiaglog(void)
   {
      NORMAL_M_ASSERT(NULL != _diaglogclienthandler);
      return *_diaglogclienthandler;
   };

   IBmCoreRequestIf& getBmCoreRequestIf(void)
   {
      NORMAL_M_ASSERT(NULL != _bmCoreRequestIf);
      return *_bmCoreRequestIf;
   }

   /** 
    * getOutputWrapper():
    *
    * @return pointer to OutputWrapper
    */
   CCAOutputWrapper &getOutputWrapper (void)
   {
      NORMAL_M_ASSERT(NULL != _outputWrapper);
      return *_outputWrapper;
   };

   diaglib::tclServiceDiaglib*            _diaglibservice;
   fc_bluetooth_tclClientHandler_Diaglib* _diaglibclienthandler;
   fc_bluetooth_tclClientHandler_Diaglog* _diaglogclienthandler;

private:
   FC_Bluetooth_tclCCAService* _bluetoothCCAService; /** Pointer to Bluetooth CCA Service */
   CCAOutputWrapper* _outputWrapper; /** Pointer to Output Wrapper */

   FC_Bluetooth_tclAudioRouting*   _audiorouting;
   fc_bluetooth_tclClientHandler_MediaPlayer*   _mediaplayerclienthandler;
   fc_bluetooth_tclClientHandler_SpmCore*   _spmcoreclienthandler;
   fc_bluetooth_tclClientHandler_DefSetHandler* _defsetclienthandler;
   fc_bluetooth_tclClientHandler_Phone*         _phoneclienthandler;
   FC_Bluetooth_TestCommand* _testCommand;

   bmcore::IBmCoreRequestIf* _bmCoreRequestIf;
}; 

/** @} */

#endif //_FC_BLUETOOTH_MAIN_H_

