/**
 * @file FC_Bluetooth_clienthandler_SystemState.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for Phone client handler
 * @{
 */

#ifndef _FC_BLUETOOTHSETTINGS_CLIENTHANDLER_PHONE_H_
#define _FC_BLUETOOTHSETTINGS_CLIENTHANDLER_PHONE_H_

class ahl_tclBaseOneThreadClientHandler;

class fc_bluetooth_tclClientHandler_Phone : public ahl_tclBaseOneThreadClientHandler
{
  public:

   static fc_bluetooth_tclClientHandler_Phone *m_poClientHandlerPhone;

    fc_bluetooth_tclClientHandler_Phone(tVoid);
    fc_bluetooth_tclClientHandler_Phone(fc_bluetooth_tclApp* poMainAppl);
    virtual ~fc_bluetooth_tclClientHandler_Phone();

    static fc_bluetooth_tclClientHandler_Phone* poGetInstance(tVoid)
    {
       return m_poClientHandlerPhone;
    }

    // Assingment Operater, will not be implemented.
    // Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
    // 'fc_bluetooth_tclClientHandler_Phone' which has no assignment operator.
    // NOTE: This is a technique to disable the assignment operator for this
    // class. So if an attempt for the assignment is made compiler complains.
    
    fc_bluetooth_tclClientHandler_Phone& operator=
      (const fc_bluetooth_tclClientHandler_Phone &oClientHandler);

    
    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    tBool vGetCallStatus();

    DECLARE_MSG_MAP(fc_bluetooth_tclClientHandler_Phone)

  private:

    /****************************************************************************
                  Member variables for ClientHandler_Phone
	 ****************************************************************************/
    tVoid  OnCallStatusNoticeStatus(amt_tclServiceData* poMessage);
    tVoid  OnCallStatusNoticeError(amt_tclServiceData* poMessage);

    tBool  m_bIsCallStatusCalled;
};

#endif // _FC_PHONE_CLIENTHANDLER_BLUETOOTHSETTINGS_H_

