/**
 * @file FC_Bluetooth_clienthandler_MediaPlayer.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief ClientHandler for the service of the Mediaplayer
 *
 * @{
 */
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#ifndef _FC_BLUETOOTHSETTINGS_CLIENTHANDLER_MEDIAPLAYER_H_
#define _FC_BLUETOOTHSETTINGS_CLIENTHANDLER_MEDIAPLAYER_H_

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
//Include FI interface of used service
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_TYPES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_FUNCTIONIDS
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_ERRORCODES
#define MPLAY_FI_S_IMPORT_INTERFACE_MPLAY_APPCONTROLFI_SERVICEINFO

#include "mplay_fi_if.h"
#include "Lock.h"
#include "FC_Bluetooth_CCAService.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;

class fc_bluetooth_tcl_DIPODeviceConnections : public mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus
{
public:
   fc_bluetooth_tcl_DIPODeviceConnections(tVoid)
   { };
   virtual ~fc_bluetooth_tcl_DIPODeviceConnections()
   {
   }
   ;
   fc_bluetooth_tcl_DIPODeviceConnections& operator=(mplay_appcontrolfi_tclMsgDiPODeviceConnectionsStatus& oData);

};

class fc_bluetooth_tclClientHandler_MediaPlayer : public ahl_tclBaseOneThreadClientHandler
{
public:

   fc_bluetooth_tclClientHandler_MediaPlayer(tVoid);
   fc_bluetooth_tclClientHandler_MediaPlayer(fc_bluetooth_tclApp* poMainAppl);
   virtual ~fc_bluetooth_tclClientHandler_MediaPlayer();

   static fc_bluetooth_tclClientHandler_MediaPlayer* poGetInstance();

   // Assingment Operater, will not be implemented.
   // Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
   // 'fc_phonebook_tclClientHandler_StreamRouter' which has no assignment operator.
   // NOTE: This is a technique to disable the assignment operator for this
   // class. So if an attempt for the assignment is made compiler complains.

   fc_bluetooth_tclClientHandler_MediaPlayer& operator=(
         const fc_bluetooth_tclClientHandler_MediaPlayer &oClientHandler);

   /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   tBool bCheckDeviceIsIphone_ConnectedToMediaPlayer(DeviceId deviceHandle, std::string szDeviceName);

   tVoid vDisconnectAndBlockAVPProfile(DeviceId deviceHandle);

   tVoid vUnblockAndConnectAVPProfile(DeviceId deviceHandle, enBlockInfo blockInfo);

   tBool bExecuteAVPConnectDisconnectOnDeviceListUpdate();

   /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/

   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();

   DECLARE_MSG_MAP(fc_bluetooth_tclClientHandler_MediaPlayer)

private:
   tVoid onDIPODeviceConnectionsStatus(amt_tclServiceData* poMessage);

   fc_bluetooth_tclApp* _bluetoothApp; /** Pointer to Main Application */

   static fc_bluetooth_tclClientHandler_MediaPlayer *_mediaplayerinstance;

   fc_bluetooth_tcl_DIPODeviceConnections _DIPODeviceConnectionStatus;

   tU8 _u8CounterIphoneConnected;

   Lock _dIPOConnectionChangedLock;
};

#endif // _FC_BLUETOOTHSETTINGS_CLIENTHANDLER_MEDIAPLAYER_H_
