/**
 * @file FC_Bluetooth_clienthandler_Diaglib.h
 * @author
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief ClientHandler for the service of the Diaglog
 * @{
 */

// +++ Remove feature switch when not needed. Used to turn diaglib support on/off +++
#ifndef _FC_BLUETOOTH_CLIENTHANDLER_DIAGLIB_H_
#define _FC_BLUETOOTH_CLIENTHANDLER_DIAGLIB_H_

typedef struct
{
   tU8 u8NotiType;
   tU8 u8Status_TMComp;
} S_TestmodeStatus_t;

//---sbv2hi--- Event handle on which Diag Caller waits for BT_APPL responses
#define EVENT_FUSION                0x00000001
#define BDADDR_LENGTH               6
#define BT_TESTMODE_WAIT_DURATION	10000 //10seconds

/**
 * Message are received by implementing ListenerInterfaces and registering
 * them with diagnosis library. This demo shows two ways to achieve this.
 * SystemSets are handled in this class. For RoutineControl we create an
 * extra classe that handles requests for two different routines.
 */

class fc_bluetooth_tclClientHandler_Diaglib : public diaglib::tclRoutineControlListenerIF,
      public diaglib::tclDiagnosisDataListenerIF
{
public:

   static fc_bluetooth_tclClientHandler_Diaglib *m_poBtDiaglib;

   tVoid vTestmodeStatus(const S_TestmodeStatus_t* const prCallData);

   tVoid vLinkQualityStatus(const BmResult bmResult, const LinkQualityInfo& linkQualityInfo);

   tVoid vDiagCallStatus(const tU8 u8CallState);

   static fc_bluetooth_tclClientHandler_Diaglib* poGetInstance(tVoid);

   tVoid vReleaseEventFusionOnShutdown();

   inline void setEnableAnswer(const tBool enable) { m_bEnableAnswer = enable; }

   // +++ Depending on the type of listener you need the associated interface to send responses +++
   fc_bluetooth_tclClientHandler_Diaglib(fc_bluetooth_tclApp* poMainAppl, diaglib::tclServiceDiaglib* pDiaglibService);

   virtual ~fc_bluetooth_tclClientHandler_Diaglib();

   // +++ Place the virtual listener functions here. These depend on the listener you implement +++

   /***************************************************************************
    * RoutineControl methods
    ***************************************************************************/
   virtual tU32 vOnGetRoutineResult(tU32 u32RoutineId, diaglib::tContext MsgContext);

   virtual tU32 vOnRoutineControlAbort(tU32 u32RoutineId, diaglib::tContext MsgContext);

   virtual tU32 vOnRoutineControlStart(tU32 u32RoutineId, tU32 u32Bitmask,
         const diaglib::tclParameterVector& oParamVector, diaglib::tContext MsgContext);

   virtual tU32 vOnDiagnosisDataRead(tU32 u32DiagDataId,
         diaglib::tContext MsgContext);

   tU32 vOnDiagnosisDataWrite(tU32 u32DiagDataId, const diaglib::tclParameterVector& oParamVector,
         diaglib::tContext MsgContext);

   tVoid vUpdateWifiDtc(tBool& bUpdate, tBool& bMacAddressfound);

private:

   fc_bluetooth_tclApp* _bluetoothApp; /** Pointer to Main Application */
   diaglib::tclServiceDiaglib* m_poDiaglibService;

   // tBool m_bServerAvailable;
   tU8 m_au8BDAddress[BDADDR_LENGTH];
   tU8 m_au8MacAddress[BDADDR_LENGTH];
   tU8 m_u8TestmodeStatus_NotiType;
   tU8 m_u8TestmodeStatus_Status;
   BmResult m_bLinkQuality_Status;
   LinkQualityInfo m_linkQualityInfo;
   tS8 m_s8CallStatus;
   OSAL_tEventHandle m_hEvFusion;
   tBool m_bFusionCBPending;
   tBool m_bEnableAnswer;

   fc_bluetooth_tclClientHandler_Diaglib(); //lint !e1704 Info 1704 , eliminating lint warnings

   void vCheckDBusInit(void);

   struct sockaddr_ll* getWifiAddress();
};

#endif // _FC_BLUETOOTH_CLIENTHANDLER_DIAGLIB_H_
