/**
 * @file FC_Bluetooth_CCAMethodMap.h
 * @author 
 * @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * @addtogroup FC_Bluetooth
 *
 * @brief Public interface for Bluetooth CCAMethodMap
 * @{
 */

#ifndef _FC_BLUETOOTH_CCAMETHODMAP_H_
#define _FC_BLUETOOTH_CCAMETHODMAP_H_

#include <list>
#include <map>
#include <cstddef>
#include "Lock.h"

// TODO: Queue size shall change as per the requirement
#define MAX_METHOD_INSERT_INTO_QUEUE 10

// TODO: Function ID is used to get the Job list in Map
#define ADDNEWDEVICE_METHOD_FKTID         0x201
#define PAIRINGRESPONSE_METHOD_FKTID      0x202
#define CHANGEPIN_METHOD_FKTID            0x204
#define CHANGEDEVICESTATE_METHOD_FKTID    0x207
#define REQDEVRINGTONELIST_METHOD_FKTID   0x209
#define REQAVAILRINGTONELIST_METHOD_FKTID 0x210
#define PLAYRINGTONE_METHOD_FKTID         0x211
#define CLEARDEVICEINFO_METHOD_FKTID      0X22A
#define GETDEVICEINFO_METHOD_FKTID        0x22B // For this Method, queue is not required because it have direct return value
#define GETDEVICEINFOEXT_METHOD_FKTID     0xF33 // For this Method, queue is not required because it have direct return value
#define SWITCHBTONOFF_METHOD_FKTID        0xF34
#define STOPRINGTONE_METHOD_FKTID         0xF35
#define SCANBTDEVICES_METHOD_FKTID        0xF36
#define CONNECTPROFILE_METHOD_FKTID       0xF37
#define DISCONNECTPROFILE_METHOD_FKTID    0xF38
#define SENDPAIRINGREQUEST_METHOD_FKTID   0xF39
#define SWITCHBTLOCALMODE_METHOD_FKTID    0xF3A
#define STARTAUTOCONNECTSEQ_METHOD_FKTID  0xF3B
#define CONNECTSPPSERVICE_METHOD_FKTID    0xF3C
#define SETBTLIMITATIONMODE_METHOD_FKTID  0xF3D
#define SWITCHBTONOFFEXT_METHOD_FKTID     0xF3E
#define CHANGEWIFITXPOWER_METHOD_FKTID    0xF3F
#define DISCONNECTSPPSERVICE_METHOD_FKTID    0xF40
#define STARTSEARCHSPPSERVICES_METHOD_FKTID  0xF41
#define STOPSEARCHSPPSERVICES_METHOD_FKTID   0xF42
#define ADDOOBPAIREDDEVICE_METHOD_FKTID      0xF43
#define SETFAVORITE_METHOD_FKTID             0xF44
#define CLEARFAVORITE_METHOD_FKTID           0xF45
#define SWITCHMULTIHFPSUPPORT_METHOD_FKTID   0xF46
#define SETPRIMARY_METHOD_FKTID              0xF47
#define SETBTPROFILESUSAGE_METHOD_FKTID      0xF48
#define RESOLVE_CONFLICTS_METHOD_FKTID       0xF49
#define SETUSAGEPREFERENCE_METHOD_FKTID      0xF4A
#define SETPROFILEUSERAVAILABILITY_METHOD_FKTID      0xF4B
#define REPLACEBTLIMITATIONMODE_METHOD_FKTID 0xF4C

#define DUMMY_METHOD_FKID                 0x01

// TODO: structure to be changed as class and operator overloading and
// constructor to be overloaded
typedef struct _Job
{
   tU16 u16SourceAppID;
   tU16 u16RegisterID;
   tU16 u16CmdCounter;
   tU16 u16FunctionID;
   tBool bResponse;
   void *poMethodArg;

   bool operator==(const _Job& rhs) const;
   //!Fix for CID 21055: Uninitialized pointer field (UNINIT_CTOR)
   _Job():u16SourceAppID(0u),u16RegisterID(0u),u16CmdCounter(0u),
		   u16FunctionID(0u), bResponse(false),poMethodArg(NULL)
   {

   }
} Job;

typedef std::list<Job> JobList;

class FC_Bluetooth_CCAMethodQueue
{
private:

   std::map<tU16, JobList*> MethodMap;

    Lock _lock;

    static FC_Bluetooth_CCAMethodQueue* m_poMethodQueue; /** Pointer to CCA Message Queue */

public:

    FC_Bluetooth_CCAMethodQueue();

    ~FC_Bluetooth_CCAMethodQueue();

    static FC_Bluetooth_CCAMethodQueue* poGetInstance();

    void PushMethodContext(tU16, Job);

    JobList* PopMethodContext(tU16);

    JobList* GetMethodContext(tU16);

    void PopParticularMethodContext(tU16, Job, tU16);

    tBool GetMethodContext(tU16 uiFunction_ID, Job &f_rJob);

    tU8 GetMethodContextListSize(tU16 uiFunction_ID);
};

#endif // _FC_BLUETOOTH_CCAMETHODMAP_H_
