#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/UserDecisionRequiredPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "UserDecisionRequiredPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"
//#include "BmCoreIfMessagesCreator.h"

namespace bmcore
{
   UserDecisionRequiredPropHdl::UserDecisionRequiredPropHdl(BmCoreMainController& bmCoreMainController) :
                 _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _issueInfoList()
   {
      ENTRY_INTERNAL
   }//End of UserDecisionRequiredPropHdl::UserDecisionRequiredPropHdl(...)

   UserDecisionRequiredPropHdl::~UserDecisionRequiredPropHdl()
   {
      ENTRY_INTERNAL
   }//End of UserDecisionRequiredPropHdl::~UserDecisionRequiredPropHdl()

   void UserDecisionRequiredPropHdl::get(IssueInfoList& issueInfoList)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);
      issueInfoList = _issueInfoList;
   }//End of void UserDecisionRequiredPropHdl::get(IssueInfoList& issueInfoList)

   void UserDecisionRequiredPropHdl::set(const IssueInfoList& issueInfoList, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((issueInfoList != _issueInfoList) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _issueInfoList = issueInfoList;
         this->onUserDecisionReqdInfoChanged();
      }//End of if ((issueInfoList != _issueInfoList) || (true == _firstUpdate) || (true == forcedUpdate))
   }//End of void UserDecisionRequiredPropHdl::set(const IssueInfoList& issueInfoList,...)

   void UserDecisionRequiredPropHdl::onUserDecisionReqdInfoChanged()
   {
      ENTRY

      /*IssueInfoList issueInfolist;
      this->get(issueInfolist);*/

      ETG_TRACE_USR1(("onUserDecisionReqdInfoChanged: reporting changed UserDecisionRequiredInfo"));

      //!Update the updated conflicts list to the registered clients
      LocalSpm::getBmCoreCallbackIfWrapper().doOnUserDecisionRequiredSignal(_issueInfoList);

      _bmCoreMainController.handlePropertyChange_UserDecisionReqdInfo(_issueInfoList);
   }//End of void UserDecisionRequiredPropHdl::onUserDecisionReqdInfoChanged()
}





