/****************************************************************************
*FILE:         TestModeLinkQualityPropHdl.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  TestModeLinkQualityProperty Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/TestModeLinkQualityPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "TestModeLinkQualityPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"

namespace bmcore
{
   TestModeLinkQualityPropHdl::TestModeLinkQualityPropHdl(IN BmCoreMainController& bmCoreMainController) :
		 _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _testModeLinkQuality()
   {
      ENTRY_INTERNAL
   }

   TestModeLinkQualityPropHdl::~TestModeLinkQualityPropHdl()
   {
      ENTRY_INTERNAL
   }

   void TestModeLinkQualityPropHdl::get(OUT TestModeLinkQuality& testModeLinkQuality)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      testModeLinkQuality = _testModeLinkQuality;
   }

   void TestModeLinkQualityPropHdl::set(IN const TestModeLinkQuality& testModeLinkQuality, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((testModeLinkQuality != _testModeLinkQuality) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _testModeLinkQuality = testModeLinkQuality;

         this->onTestModeLinkQualityChanged(testModeLinkQuality);
      }
   }

   void TestModeLinkQualityPropHdl::onTestModeLinkQualityChanged(IN const TestModeLinkQuality& testModeLinkQuality)
   {
      ETG_TRACE_USR1(("onTestModeLinkQualityChanged: TestModeLinkQuality changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnLinkQualityTestModeChanged(testModeLinkQuality);

      //_bmCoreMainController.handlePropertyChange_BlockStatus(blockStatus);
   }
}
