#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PairingStatusPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "PairingStatusPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"

namespace bmcore
{
   PairingStatusPropHdl::PairingStatusPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _pairingStatus()
   {
      ENTRY_INTERNAL
   }

   PairingStatusPropHdl::~PairingStatusPropHdl()
   {
      ENTRY_INTERNAL
   }

   void PairingStatusPropHdl::get(PairingStatus& pairingStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      pairingStatus = _pairingStatus;
   }

   void PairingStatusPropHdl::set(const PairingStatus& pairingStatus, const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if (((BM_PAIRING_STATE_PAIRING_IN_PROGRESS == _pairingStatus._state) || (BM_PAIRING_STATE_PAIRING_PREPARED == _pairingStatus._state))
            && (BM_PAIRING_STATE_IDLE == pairingStatus._state))
      {
         Result result = LocalSpm::getBmCoreMainController().updateLegacyPairingPin();

         if (CC_ERR_INT_NO_ERROR != result)
         {
            ETG_TRACE_ERR(("set: updating legacy pairing PIN failed (error = %d)", result));
         }
      }

      if ((pairingStatus != _pairingStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _pairingStatus = pairingStatus;

         this->onPairingStatusChanged(pairingStatus);
      }
   }

   void PairingStatusPropHdl::onPairingStatusChanged(IN const PairingStatus& pairingStatus)
   {
      ETG_TRACE_USR1(("onPairingStatusChanged: PairingStatus changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnPairingStatusChanged(pairingStatus);

      //_bmCoreMainController.handlePropertyChange_PairingStatus(pairingStatus);
   }
}

