#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/PairedDeviceListPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "PairedDeviceListPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   PairedDeviceListPropHdl::PairedDeviceListPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _pairedDeviceList()
   {
      ENTRY_INTERNAL
   }

   PairedDeviceListPropHdl::~PairedDeviceListPropHdl()
   {
      ENTRY_INTERNAL
   }

   void PairedDeviceListPropHdl::get(PairedDeviceList& pairedDeviceList)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      pairedDeviceList = _pairedDeviceList;
   }

   void PairedDeviceListPropHdl::set(IN const PairedDeviceList& pairedDeviceList,
         IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      PairedDeviceList sortedPairedDeviceList(pairedDeviceList);

      sortedPairedDeviceList._deviceBaseInfoList.sort(DeviceBaseInfo::compConnectionIndex);

      if ((sortedPairedDeviceList != _pairedDeviceList) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _pairedDeviceList = sortedPairedDeviceList;
         this->onPairedDeviceListChanged(sortedPairedDeviceList);
      }
   }

   void PairedDeviceListPropHdl::onPairedDeviceListChanged(IN const PairedDeviceList& pairedDeviceList)
   {
      ENTRY

      ETG_TRACE_USR1(("onPairedDeviceListChanged: PairedDeviceList changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnPairedDeviceListChanged(pairedDeviceList);

      _bmCoreMainController.handlePropertyChange_PairedDeviceList(pairedDeviceList);
   }
}
