#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/MultiHFPSupportSwitchPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "MultiHFPSupportSwitchPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"

namespace bmcore
{
   MultiHFPSupportSwitchPropHdl::MultiHFPSupportSwitchPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _deviceId(0),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF), _switchStatus()
   {
      ENTRY_INTERNAL
   }

   MultiHFPSupportSwitchPropHdl::~MultiHFPSupportSwitchPropHdl()
   {
      ENTRY_INTERNAL
   }

   TargetSwitchState MultiHFPSupportSwitchPropHdl::getTargetSwitchState(void) const
   {
      ENTRY_INTERNAL

      return _targetSwitchState;
   }

   DeviceId MultiHFPSupportSwitchPropHdl::getDeviceId(void) const
   {
      ENTRY_INTERNAL

      return _deviceId;
   }

   void MultiHFPSupportSwitchPropHdl::get(INOUT SwitchStatus& switchStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      switchStatus = _switchStatus;
   }

   void MultiHFPSupportSwitchPropHdl::setTargetSwitchState(IN const TargetSwitchState targetSwitchState,
         IN const BmCoreIfMsgOrigin origin, IN const ActType act)
   {
      ENTRY

      SwitchStatus switchStatus(_switchStatus);

      if (targetSwitchState != _targetSwitchState)
      {
         if (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_OFF)
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;

                  onInternalSwitchStateUpdate(SWITCH_STATE_SWITCHED_OFF, origin);
                  break;
               case SWITCH_STATE_SWITCHED_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;

                  switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;

                  this->set(switchStatus, origin);

                  if (0 != this->doRequestInternalSwitching(targetSwitchState, origin))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                     this->set(switchStatus, origin);
                  }
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               default:
                  break;
            }
         }
         else // i.e. targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;

                  onInternalSwitchStateUpdate(SWITCH_STATE_SWITCHED_ON, origin);
                  break;
               case SWITCH_STATE_SWITCHED_OFF:
               {
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;

                  switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
                  this->set(switchStatus, origin);

                  if (0 != this->doRequestInternalSwitching(targetSwitchState, origin))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                     this->set(switchStatus, origin);
                  }

                  break;
               }
               default:
                  break;
            }
         }

         if(BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
         {
            Result result = LocalSpm::getDbManager().setMultiHFPSupportStatus((int)_targetSwitchState);

            if (CC_ERR_INT_NO_ERROR != result)
            {
               ETG_TRACE_ERR(("setTargetSwitchState: storing MultiHFPSupport Status' target switch state to DB failed (error = %d)",
                     ETG_CENUM(CcErrorInternal, result)));
            }
         }
      }
      else // i.e. targetSwitchState == _targetSwitchState
      {
         this->doRespondSwitching(0, origin, act);

         this->set(switchStatus, origin); // call needed for doing an initial reporting of
                                          // property to client
      }
   }

   void MultiHFPSupportSwitchPropHdl::doRespondSwitching(IN const Result result, IN const BmCoreIfMsgOrigin origin,
         IN const ActType act) const
   {
      if (BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
      {
         BmResult bmResult(BM_RESULT_OK);

         if (0 != result)
         {
            bmResult = BM_RESULT_ERR_GENERAL;
         }

         // respond to client's request synchronously
         LocalSpm::getBmCoreCallbackIfWrapper().doSwitchMultiHFPSupportResponse(bmResult, act);
      }
   }

   void MultiHFPSupportSwitchPropHdl::set(IN const SwitchStatus& switchStatus, IN const BmCoreIfMsgOrigin origin, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((switchStatus != _switchStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _switchStatus = switchStatus;

         _deviceId = 0;

         this->onSwitchStatusChanged(origin);
      }
   }

   void MultiHFPSupportSwitchPropHdl::onSwitchStatusChanged(IN const BmCoreIfMsgOrigin origin)
   {
      ETG_TRACE_USR1(("onSwitchStatusChanged: MultiHFPSupportStatus changed"));

      (void) origin;

      SwitchStatus switchStatus;
      this->get(switchStatus);

      LocalSpm::getBmCoreCallbackIfWrapper().doOnMultiHFPSupportStatusChanged(switchStatus);

      _bmCoreMainController.handlePropertyChange_MultiHFPSupportStatus(switchStatus);
   }

   void MultiHFPSupportSwitchPropHdl::onInternalSwitchStateUpdate(IN const SwitchState internalSwitchState,
         IN const BmCoreIfMsgOrigin origin)
   {
      ENTRY

      ETG_TRACE_USR1(("onInternalSwitchStateUpdate: internalSwitchState = %d", ETG_CENUM(SwitchState, internalSwitchState)));

      SwitchStatus switchStatus(_switchStatus);

      if (SWITCH_STATE_SWITCHED_ON == internalSwitchState)
      {
         if (TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
         {
            // target: off
            // present: *
            // reported: off

            switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;

            if(BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
            {
               switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
            }
            else
            {
               switchStatus._switchedOffReason = SWITCHED_OFF_REASON_INTERNAL;
            }
            this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_INTERNAL);
         }

         if (TARGET_SWITCH_STATE_SWITCHED_ON == _targetSwitchState)
         {
            if (SWITCH_STATE_SWITCHING_OFF == switchStatus._switchState)
            {
               // target: on
               // present: switching off
               // reported: on

               switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
               this->set(switchStatus, origin);

               if (0 != this->doRequestInternalSwitching(TARGET_SWITCH_STATE_SWITCHED_ON))
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                  this->set(switchStatus, origin);
               }
            }
            else
            {
               // target: on
               // present: not switching off
               // reported: on

               _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

               switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
               switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
               this->set(switchStatus, origin);
            }
         }
      }
      else // i.e. switchState == SWITCH_STATE_SWITCHED_OFF
      {
         if (TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
         {
            if (SWITCH_STATE_SWITCHING_ON == switchStatus._switchState)
            {
               switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;
               this->set(switchStatus, origin);

               if (0 != this->doRequestInternalSwitching(TARGET_SWITCH_STATE_SWITCHED_OFF))
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                  this->set(switchStatus, origin);
               }
            }
            else
            {
               _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

               switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
               if(BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
               {
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
               }
               else
               {
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_INTERNAL;
               }
               this->set(switchStatus, origin);
            }
         }
         else
         {
            if (SWITCH_STATE_SWITCHED_OFF != switchStatus._switchState)
            {
               switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
               if(BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
               {
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
               }
               else
               {
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_INTERNAL;
               }
               this->set(switchStatus, origin);
            }
         }
      }
   }

   Result MultiHFPSupportSwitchPropHdl::doRequestInternalSwitching(IN const TargetSwitchState targetSwitchState
         , IN const BmCoreIfMsgOrigin origin)
   {
      ETG_TRACE_USR1(("doRequestInternalSwitching: switching %10s MultiHFPSupport at BMCore",
            (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON) ? "ON" : "OFF"));

      Result result(CC_ERR_INT_NO_ERROR);

      if (TARGET_SWITCH_STATE_SWITCHED_ON == targetSwitchState)
      {
         SwitchStatus switchStatus(_switchStatus);
         switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
         this->set(switchStatus);
      }
      else
      {
         DeviceId deviceId = 0;
         result = LocalSpm::getDbManager().getSecondaryHfpDevice(deviceId);

         if (CC_ERR_INT_NO_ERROR == result)
         {
            if(0 != deviceId)
            {
               ProtocolList protocolList;

               protocolList.clear();
               Protocol protocol;
               protocol._protocolId = BM_PROTOCOL_ID_HFP;
               protocol._uuid = "";
               protocolList.push_back(protocol);

               BmResult bmResult = LocalSpm::getBmCoreMainController().disconnectProfilesInt(deviceId, protocolList);

               if (BM_RESULT_OK != bmResult)
               {
                  ETG_TRACE_ERR(("doRequestInternalSwitching: disconnecting profiles failed (bmResult = %d)",
                        ETG_CENUM(BmResult, bmResult)));
               }
               else
               {
                  _deviceId = deviceId;
                  ETG_TRACE_USR1(("doRequestInternalSwitching: wait for the profiles getting disconnected - HFP request deviceID- %d",
                        _deviceId));
                  return result;
               }
            }
         }
         else
         {
            ETG_TRACE_ERR(("doRequestInternalSwitching: could not get SecondaryHfpDevice (error = %d)",
                  ETG_CENUM(CcErrorInternal, result)));
         }

         SwitchStatus switchStatus(_switchStatus);
         switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;

         if(BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
         {
            switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
         }
         else
         {
            switchStatus._switchedOffReason = SWITCHED_OFF_REASON_INTERNAL;
         }

         this->set(switchStatus);
      }

      return result;
   }
}
