#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LocalPairableModeSwitchPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "LocalPairableModeSwitchPropHdl.h"
#include "LocalSpm.h"
#include "BmVarTrace.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LocalPairableModeSwitchPropHdl::LocalPairableModeSwitchPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true),
         _targetSwitchState(TARGET_SWITCH_STATE_SWITCHED_OFF), _switchStatus(),
         _externalSwitchState(SWITCH_STATE_SWITCHED_OFF), _switchedOffReason(SWITCHED_OFF_REASON_CLIENT), _numPendingBtsPairableRequests(0)
   {
      ENTRY_INTERNAL
   }

   LocalPairableModeSwitchPropHdl::~LocalPairableModeSwitchPropHdl()
   {
      ENTRY_INTERNAL
   }

   TargetSwitchState LocalPairableModeSwitchPropHdl::getTargetSwitchState(void) const
   {
      ENTRY_INTERNAL

      return _targetSwitchState;
   }

   void LocalPairableModeSwitchPropHdl::get(INOUT SwitchStatus& switchStatus)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      switchStatus = _switchStatus;
   }

   void LocalPairableModeSwitchPropHdl::setTargetSwitchState(IN const TargetSwitchState targetSwitchState,
         IN const BmCoreIfMsgOrigin origin, IN const ActType act)
   {
      ENTRY

      ETG_TRACE_USR1(("setTargetSwitchState: Current targetSwitchState = %d, Requested targetSwitchState = %d",
               ETG_CENUM(TargetSwitchState, _targetSwitchState), ETG_CENUM(TargetSwitchState, targetSwitchState)));

      SwitchStatus switchStatus(_switchStatus);

      ETG_TRACE_USR4(("setTargetSwitchState: Current Switch State = %d", ETG_CENUM(SwitchState, switchStatus._switchState)));

      if (targetSwitchState != _targetSwitchState)
      {
         if (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_OFF)
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHED_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;

                  switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;

                  this->set(switchStatus, origin);

                  if (0 != this->doRequestExternalSwitching(targetSwitchState))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                     this->set(switchStatus, origin);
                  }
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               default:
                  break;
            }
         }
         else // i.e. targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON
         {
            switch (switchStatus._switchState)
            {
               case SWITCH_STATE_SWITCHING_ON:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHING_OFF:
                  this->doRespondSwitching(0, origin, act);

                  _targetSwitchState = targetSwitchState;
                  break;
               case SWITCH_STATE_SWITCHED_OFF:
               {
                  if ((SWITCHED_OFF_REASON_CLIENT == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_TIMEOUT == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_INTERNAL == switchStatus._switchedOffReason)
                        || (SWITCHED_OFF_REASON_ERROR == switchStatus._switchedOffReason))
                  {
                     this->doRespondSwitching(0, origin, act);

                     _targetSwitchState = targetSwitchState;

                     switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
                     this->set(switchStatus, origin);

                     if (0 != this->doRequestExternalSwitching(targetSwitchState))
                     {
                        _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                        switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                        switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                        this->set(switchStatus, origin);
                     }
                  }
                  else
                  {
                     this->doRespondSwitching(1, origin, act);
                  }
                  break;
               }
               default:
                  break;
            }
         }
      }
      else // i.e. targetSwitchState == _targetSwitchState
      {
         this->doRespondSwitching(0, origin, act);

         this->set(switchStatus, origin); // call needed for doing an initial reporting of
                                             // property to client
      }
   }

   void LocalPairableModeSwitchPropHdl::onExternalSwitchingResponse(IN const CcErrorInternal result)
   {
      ENTRY

      ETG_TRACE_USR1(("onExternalSwitchingResponse: result = %d",
            ETG_CENUM(CcErrorInternal, result)));

      this->updateNumPendingBtsPairableRequests(false);
   }

   void LocalPairableModeSwitchPropHdl::onExternalSwitchStateUpdate(IN const SwitchState externalSwitchState,
         IN const SwitchedOffReason switchedOffReason)
   {
      ENTRY

      ETG_TRACE_USR1(("onExternalSwitchStateUpdate: externalSwitchState = %d",
            ETG_CENUM(SwitchState, externalSwitchState)));

      _externalSwitchState = externalSwitchState;
      _switchedOffReason = switchedOffReason;

      this->checkNumPendingBtsPairableRequests();
   }

   void LocalPairableModeSwitchPropHdl::doRespondSwitching(IN const Result result, IN const BmCoreIfMsgOrigin origin,
         IN const ActType act) const
   {
      if (BM_CORE_IF_MSG_ORIGIN_CLIENT == origin)
      {
         BmResult bmResult(BM_RESULT_OK);

         if (0 != result)
         {
            bmResult = BM_RESULT_ERR_GENERAL;
         }

         // respond to client's request synchronously
         LocalSpm::getBmCoreCallbackIfWrapper().doSwitchLocalPairableModeResponse(bmResult, act);
      }
   }

   void LocalPairableModeSwitchPropHdl::set(IN const SwitchStatus& switchStatus, IN const BmCoreIfMsgOrigin origin,
         IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((switchStatus != _switchStatus) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _switchStatus = switchStatus;
         this->onSwitchStatusChanged(origin);
      }
   }

   void LocalPairableModeSwitchPropHdl::onSwitchStatusChanged(IN const BmCoreIfMsgOrigin origin)
   {
      (void) origin;

      SwitchStatus localPairableMode;
      this->get(localPairableMode);

      ETG_TRACE_USR1(("onSwitchStatusChanged: LocalPairableMode changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnLocalPairableModeChanged(localPairableMode);

      _bmCoreMainController.handlePropertyChange_LocalPairableMode(localPairableMode);
   }

   Result LocalPairableModeSwitchPropHdl::doRequestExternalSwitching(IN const TargetSwitchState targetSwitchState)
   {
      ETG_TRACE_USR1(("doRequestExternalSwitching: switching %10s local pairable mode at BtStackIf",
            (targetSwitchState == TARGET_SWITCH_STATE_SWITCHED_ON) ? "ON" : "OFF"));

      Result result(0);

      if (TARGET_SWITCH_STATE_SWITCHED_ON == targetSwitchState)
      {
         _bmCoreMainController.getBtStackIfConnectionRequestIfWrapper().setLocalAdapterModes(BTS_MODE_ENABLED,
               (TARGET_SWITCH_STATE_SWITCHED_OFF == LocalSpm::getDataProvider().getBmCoreConfiguration()._defaultLocalPairableMode) ?
                     LocalSpm::getDataProvider().getBmCoreConfiguration()._localPairableTimeoutSeconds : 0u, BTS_MODE_UNCHANGED, 0, BM_REQUEST_TYPE_PAIRABLE_MODE);
      }
      else
      {
         _bmCoreMainController.getBtStackIfConnectionRequestIfWrapper().setLocalAdapterModes(BTS_MODE_DISABLED, 0u, BTS_MODE_UNCHANGED, 0u, BM_REQUEST_TYPE_PAIRABLE_MODE);
      }

      this->updateNumPendingBtsPairableRequests(true);

      return result;
   }

   void LocalPairableModeSwitchPropHdl::updateNumPendingBtsPairableRequests(const bool increment)
   {
      ETG_TRACE_USR1(("updateNumPendingBtsPairableRequests: %s number", increment ? "increment" : "decrement"));

      if (true == increment)
      {
         _numPendingBtsPairableRequests++;
      }
      else
      {
         if (0u < _numPendingBtsPairableRequests)
         {
            _numPendingBtsPairableRequests--;
         }
         else
         {
            ETG_TRACE_ERR(("updateNumPendingBtsPairableRequests: number of pending BTS pairablemode requests is already 0"));
         }
      }

      this->checkNumPendingBtsPairableRequests();
   }

   void LocalPairableModeSwitchPropHdl::checkNumPendingBtsPairableRequests()
   {
      ETG_TRACE_USR1(("checkNumPendingBtsPairableRequests: number of pending requests = %d", _numPendingBtsPairableRequests));

      if (0u == _numPendingBtsPairableRequests)
      {
         SwitchStatus switchStatus(_switchStatus);

         if (SWITCH_STATE_SWITCHED_OFF == _externalSwitchState)
         {
            if ((TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
                  && (SWITCH_STATE_SWITCHED_OFF != switchStatus._switchState))
            {
               switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
               switchStatus._switchedOffReason = SWITCHED_OFF_REASON_CLIENT;
               this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
            }

            if (TARGET_SWITCH_STATE_SWITCHED_ON == _targetSwitchState)
            {
               if (SWITCH_STATE_SWITCHING_OFF == switchStatus._switchState)
               {
                  switchStatus._switchState = SWITCH_STATE_SWITCHING_ON;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

                  if (0 != this->doRequestExternalSwitching(TARGET_SWITCH_STATE_SWITCHED_ON))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_ERROR;
                     this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
                  }
               }
               else
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_OFF;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_OFF;

                  if (SWITCHED_OFF_REASON_TIMEOUT == _switchedOffReason)
                  {
                     switchStatus._switchedOffReason = SWITCHED_OFF_REASON_TIMEOUT;
                  }
                  else
                  {
                     switchStatus._switchedOffReason = _switchedOffReason;
                  }

                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
         }
         else // i.e. switchState == SWITCH_STATE_SWITCHED_ON
         {
            if (TARGET_SWITCH_STATE_SWITCHED_OFF == _targetSwitchState)
            {
               if (SWITCH_STATE_SWITCHING_ON == switchStatus._switchState)
               {
                  switchStatus._switchState = SWITCH_STATE_SWITCHING_OFF;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);

                  if (0 != this->doRequestExternalSwitching(TARGET_SWITCH_STATE_SWITCHED_OFF))
                  {
                     _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                     switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                     this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
                  }
               }
               else
               {
                  _targetSwitchState = TARGET_SWITCH_STATE_SWITCHED_ON;

                  switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                  switchStatus._switchedOffReason = SWITCHED_OFF_REASON_NOT_VALID;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
            else
            {
               if (SWITCH_STATE_SWITCHED_ON != switchStatus._switchState)
               {
                  switchStatus._switchState = SWITCH_STATE_SWITCHED_ON;
                  this->set(switchStatus, BM_CORE_IF_MSG_ORIGIN_BT_STACK_IF);
               }
            }
         }
      }
   }
}
