#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LocalFriendlyNamePropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "LocalFriendlyNamePropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LocalFriendlyNamePropHdl::LocalFriendlyNamePropHdl(IN BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _localFriendlyName()
   {
      ENTRY_INTERNAL
   }

   LocalFriendlyNamePropHdl::~LocalFriendlyNamePropHdl()
   {
      ENTRY_INTERNAL
   }

   void LocalFriendlyNamePropHdl::get(LocalFriendlyName& localFriendlyName)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      localFriendlyName = _localFriendlyName;
   }

   void LocalFriendlyNamePropHdl::set(const LocalFriendlyName& localFriendlyName, const bool isExternalPropertyToBeSet,
         const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((localFriendlyName != _localFriendlyName) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _localFriendlyName = localFriendlyName;

         this->onLocalFriendlyNameChanged();

         if (true == isExternalPropertyToBeSet)
         {
            LocalSpm::getBmCoreMainController().getBtStackIfConnectionRequestIfWrapper().setLocalBtName(localFriendlyName._localFriendlyName);
         }
      }
   }

   void LocalFriendlyNamePropHdl::onLocalFriendlyNameChanged()
   {
      ENTRY

      LocalFriendlyName localFriendlyName;
      this->get(localFriendlyName);

      ETG_TRACE_USR1(("onLocalFriendlyNameChanged: reporting changed LocalFriendlyName"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnBtLocalFriendlyNameChanged(localFriendlyName);
   }
}
