/****************************************************************************
*FILE:         LinkQualityPropHdl.cpp
*SW-COMPONENT: bmcore
*DESCRIPTION:  LinkQuality Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/LinkQualityPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "LinkQualityPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   LinkQualityPropHdl::LinkQualityPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _linkQuality()
   {
      ENTRY_INTERNAL
   }

   LinkQualityPropHdl::~LinkQualityPropHdl()
   {
      ENTRY_INTERNAL
   }

   void LinkQualityPropHdl::get(OUT LinkQuality& linkQuality)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      linkQuality = _linkQuality;
   }

   void LinkQualityPropHdl::set(IN const LinkQuality& linkQuality, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((linkQuality != _linkQuality) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _linkQuality = linkQuality;

         this->onLinkQualityChanged(linkQuality);
      }
   }

   void LinkQualityPropHdl::onLinkQualityChanged(IN const LinkQuality& linkQuality)
   {
      ENTRY

      ETG_TRACE_USR1(("onLinkQualityChanged: LinkQuality changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnLinkQualityChanged(linkQuality);
   }
}
