#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DiscoveredDeviceListPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "DiscoveredDeviceListPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   DiscoveredDeviceListPropHdl::DiscoveredDeviceListPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _discoveredDeviceList()
   {
      ENTRY_INTERNAL
   }

   DiscoveredDeviceListPropHdl::~DiscoveredDeviceListPropHdl()
   {
      ENTRY_INTERNAL
   }

   void DiscoveredDeviceListPropHdl::get(DiscoveredDeviceList& discoveredDeviceList)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      discoveredDeviceList = _discoveredDeviceList;
   }

   void DiscoveredDeviceListPropHdl::set(IN const DiscoveredDeviceList& discoveredDeviceList, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((discoveredDeviceList != _discoveredDeviceList) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _discoveredDeviceList = discoveredDeviceList;
         this->onDiscoveredDeviceListChanged();
      }
   }

   void DiscoveredDeviceListPropHdl::onDiscoveredDeviceListChanged()
   {
      ENTRY

      DiscoveredDeviceList discoveredDeviceList;
      this->get(discoveredDeviceList);

      ETG_TRACE_USR1(("onDiscoveredDeviceListChanged: DiscoveredDeviceList changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnDiscoveredDeviceListChanged(discoveredDeviceList);

      //_bmCoreMainController.handlePropertyChange_DiscoveredDeviceList(discoveredDeviceList);
   }
}

