#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/DeviceConnectionStatusListPropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "DeviceConnectionStatusListPropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"
#include <algorithm>

namespace bmcore
{
   DeviceConnectionStatusListPropHdl::DeviceConnectionStatusListPropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true),
         _deviceConnectionStatusList(), _previousDeviceConnectionStatusList()
   {
      ENTRY_INTERNAL
   }

   DeviceConnectionStatusListPropHdl::~DeviceConnectionStatusListPropHdl()
   {
      ENTRY_INTERNAL
   }

   void DeviceConnectionStatusListPropHdl::get(DeviceConnectionStatusList& deviceConnectionStatusList)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      deviceConnectionStatusList = _deviceConnectionStatusList;
   }

   void DeviceConnectionStatusListPropHdl::set(IN const DeviceConnectionStatusList& deviceConnectionStatusList,
         IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      // remember current device connection status list
      _previousDeviceConnectionStatusList = _deviceConnectionStatusList;

      // sort the given device connection status list and update if different from the current one
      DeviceConnectionStatusList sortedDeviceConnectionStatusList(deviceConnectionStatusList);

      std::sort(sortedDeviceConnectionStatusList._deviceConnectionInfoList.begin(),
            sortedDeviceConnectionStatusList._deviceConnectionInfoList.end(), DeviceConnectionInfo::compConnectionIndex);

      if ((sortedDeviceConnectionStatusList != _deviceConnectionStatusList) || (true == _firstUpdate)
            || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _deviceConnectionStatusList = sortedDeviceConnectionStatusList;
         this->onDeviceConnectionStatusListChanged(sortedDeviceConnectionStatusList);
      }
   }

   void DeviceConnectionStatusListPropHdl::onDeviceConnectionStatusListChanged(IN const DeviceConnectionStatusList& deviceConnectionStatusList)
   {
      ENTRY

      ETG_TRACE_USR1(("onDeviceConnectionStatusListChanged: DeviceConnectionStatusList changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnDeviceConnectionStatusListChanged(deviceConnectionStatusList);

      _bmCoreMainController.handlePropertyChange_DeviceConnectionStatusList(deviceConnectionStatusList, _previousDeviceConnectionStatusList);
   }
}
