
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtSystemStatePropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "SwitchStatus.h"
#include "BtSystemStatePropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BtSystemStatePropHdl::BtSystemStatePropHdl(BmCoreMainController& bmCoreMainController) :
            _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true), _btSystemState()
   {
      ENTRY_INTERNAL
   }

   BtSystemStatePropHdl::~BtSystemStatePropHdl()
   {
      ENTRY_INTERNAL
   }

   void BtSystemStatePropHdl::get(BtSystemState& btSystemState)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      btSystemState = _btSystemState;
   }

   void BtSystemStatePropHdl::set(const BtSystemState& btSystemState, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((btSystemState != _btSystemState) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _btSystemState = btSystemState;

         this->onBtSystemStateChanged();

         (void) LocalSpm::getBmCoreMainController().checkAndUpdateBmServiceAvailability();

         _firstUpdate = false;
      }
   }

   void BtSystemStatePropHdl::onBtSystemStateChanged()
   {
      BtSystemState btSystemState;
      this->get(btSystemState);

      ETG_TRACE_USR1(("onBtSystemStateChanged: reporting changed BtSystemState"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnBtSystemStateChanged(btSystemState);

      //todo: think about error handling?

      if (BM_BT_SYSTEM_STATE_OFF == btSystemState._bluetoothSystemState)
      {
         (void) LocalSpm::getBmCoreMainController().updateFunctionalityRestrictionInfo(BM_RESTRICTION_BIT_BT_SYSTEM_STATE_OFF, true);
      }
      else if (BM_BT_SYSTEM_STATE_BLOCK == btSystemState._bluetoothSystemState)
      {
         (void) LocalSpm::getBmCoreMainController().updateFunctionalityRestrictionInfo(BM_RESTRICTION_BIT_BT_SYSTEM_STATE_BLOCKED, true);
      }
      else
      {
          (void) LocalSpm::getBmCoreMainController().updateFunctionalityRestrictionInfo(BM_RESTRICTION_BIT_BT_SYSTEM_STATE_OFF, false);
          (void) LocalSpm::getBmCoreMainController().updateFunctionalityRestrictionInfo(BM_RESTRICTION_BIT_BT_SYSTEM_STATE_BLOCKED, false);
      }
   }
}
