
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtLimitationModePropHdl.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_PROPERTY
#endif
#endif

#include "BtLimitationModePropHdl.h"
#include "LocalSpm.h"
#include "FunctionTracer.h"
#include "BmVarTrace.h"
#include "BmCoreIfMessagesCreator.h"

namespace bmcore
{
   BtLimitationModePropHdl::BtLimitationModePropHdl(BmCoreMainController& bmCoreMainController) :
         _bmCoreMainController(bmCoreMainController), _lock(), _firstUpdate(true),
         _btLimitationMode()
   {
      ENTRY_INTERNAL
   }

   BtLimitationModePropHdl::~BtLimitationModePropHdl()
   {
      ENTRY_INTERNAL
   }

   void BtLimitationModePropHdl::get(BtLimitationMode& btLimitationMode)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      btLimitationMode = _btLimitationMode;
   }

   void BtLimitationModePropHdl::set(IN const BtLimitationMode& btLimitationMode, IN const bool forcedUpdate)
   {
      ENTRY_INTERNAL

      Locker locker(&_lock);

      if ((btLimitationMode != _btLimitationMode) || (true == _firstUpdate) || (true == forcedUpdate))
      {
         _firstUpdate = false;

         _btLimitationMode = btLimitationMode;
         this->onBtLimitationModeChanged();
      }
   }

   void BtLimitationModePropHdl::onBtLimitationModeChanged()
   {
      ENTRY

      BtLimitationMode btLimitationMode;
      this->get(btLimitationMode);

      ETG_TRACE_USR1(("onBtLimitationModeChanged: BtLimitationMode changed"));

      LocalSpm::getBmCoreCallbackIfWrapper().doOnBtLimitationModeChanged(btLimitationMode);

      _bmCoreMainController.handlePropertyChange_BtLimitationMode(btLimitationMode);
   }
}
