
#ifndef _USER_DECISION_REQUIRED_PROP_HDL_H_
#define _USER_DECISION_REQUIRED_PROP_HDL_H_

#include "IssueInfoList.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class UserDecisionRequiredPropHdl
   {
   public:
      explicit UserDecisionRequiredPropHdl(BmCoreMainController& bmCoreMainController);

      ~UserDecisionRequiredPropHdl();

      void get(IssueInfoList& issueInfoList);

      void set(const IssueInfoList& issueInfoList, IN const bool forcedUpdate = false);

   private:

      UserDecisionRequiredPropHdl(const UserDecisionRequiredPropHdl& other);

      UserDecisionRequiredPropHdl& operator=(const UserDecisionRequiredPropHdl& rhs);

      void onUserDecisionReqdInfoChanged();

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      IssueInfoList _issueInfoList;
   };//End of class UserDecisionRequiredPropHdl
}//End of namespace bmcore

#endif // _USER_DECISION_REQUIRED_PROP_HDL_H_
