/****************************************************************************
*FILE:         TestModeLinkQualityPropHdl.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  TestModeLinkQuality Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef TESTMODELINKQUALITYPROPHDL_H_
#define TESTMODELINKQUALITYPROPHDL_H_

#include "TestModeLinkQuality.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class TestModeLinkQualityPropHdl
   {
   public:
      explicit TestModeLinkQualityPropHdl(IN BmCoreMainController& bmCoreMainController);

      ~TestModeLinkQualityPropHdl();

      void get(OUT TestModeLinkQuality& testModeLinkQuality);

      void set(IN const TestModeLinkQuality& testModeLinkQuality, IN const bool forcedUpdate = false);

   private:

      TestModeLinkQualityPropHdl(const TestModeLinkQualityPropHdl& other);

      TestModeLinkQualityPropHdl& operator=(const TestModeLinkQualityPropHdl& rhs);

      void onTestModeLinkQualityChanged(IN const TestModeLinkQuality& testModeLinkQuality);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      TestModeLinkQuality _testModeLinkQuality;
   };
}

#endif /* TESTMODELINKQUALITYPROPHDL_H_ */
