/*
 * PairingStatusPropHdl.h
 *
 *  Created on: Jun 24, 2015
 *      Author: Tharani - tnh5cob
 */

#ifndef _BT_PAIRING_STATUS_PROP_HDL_H_
#define _BT_PAIRING_STATUS_PROP_HDL_H_

#include "PairingStatus.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class PairingStatusPropHdl
   {
   public:
      explicit PairingStatusPropHdl(BmCoreMainController& bmCoreMainController);

      ~PairingStatusPropHdl();

      void get(PairingStatus& pairingStatus);

      void set(IN const PairingStatus& pairingStatus, IN const bool forcedUpdate = false);

   private:

      PairingStatusPropHdl(const PairingStatusPropHdl& other);

      PairingStatusPropHdl& operator=(const PairingStatusPropHdl& rhs);

      void onPairingStatusChanged(IN const PairingStatus& pairingStatus);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      PairingStatus _pairingStatus;
   };
}

#endif // _PAIRING_STATUS_PROP_HDL_H_
