/**
 * @headerfile PairedDeviceListPropHdl.h
 * @brief Implements the handler for PairedDeviceList property
 * @date  Jul 15, 2015
 * @author tnh5cob-Tharani
 */

#ifndef _PAIRED_DEVICE_LIST_PROP_HDL_H_
#define _PAIRED_DEVICE_LIST_PROP_HDL_H_

#include "BmAllTypes.h"
#include "PairedDeviceList.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class PairedDeviceListPropHdl
   {
   public:
      explicit PairedDeviceListPropHdl(BmCoreMainController& bmCoreMainController);

      ~PairedDeviceListPropHdl();

      void get(PairedDeviceList& pairedDeviceList);

      void set(IN const PairedDeviceList& pairedDeviceList, IN const bool forcedUpdate = false);

   private:

      PairedDeviceListPropHdl(const PairedDeviceListPropHdl& other);

      PairedDeviceListPropHdl& operator=(const PairedDeviceListPropHdl& rhs);

      void onPairedDeviceListChanged(IN const PairedDeviceList& pairedDeviceList);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      PairedDeviceList _pairedDeviceList;
   };
}

#endif // _PAIRED_DEVICE_LIST_PROP_HDL_H_
