#ifndef _LOCAL_PAIRABLE_MODE_SWITCH_PROP_HDL_H_
#define _LOCAL_PAIRABLE_MODE_SWITCH_PROP_HDL_H_

#include "SwitchStatus.h"
#include "BmAllTypesInternal.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class LocalPairableModeSwitchPropHdl
   {
   public:

      explicit LocalPairableModeSwitchPropHdl(BmCoreMainController& bmCoreMainController);

      ~LocalPairableModeSwitchPropHdl();

      TargetSwitchState getTargetSwitchState(void) const;

      void get(OUT SwitchStatus& switchStatus);

      void setTargetSwitchState(IN const TargetSwitchState targetSwitchState,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT, IN const ActType act = 0u);

      void onExternalSwitchingResponse(IN const CcErrorInternal result);

      void onExternalSwitchStateUpdate(IN const SwitchState switchState, IN const SwitchedOffReason switchedOffReason);

   private:

      LocalPairableModeSwitchPropHdl(const LocalPairableModeSwitchPropHdl& other);

      LocalPairableModeSwitchPropHdl& operator=(const LocalPairableModeSwitchPropHdl& rhs);

      void doRespondSwitching(IN const Result result, IN const BmCoreIfMsgOrigin origin, IN const ActType act) const;

      void set(IN const SwitchStatus& switchStatus, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT,
            IN const bool forcedUpdate = false);

      void onSwitchStatusChanged(IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      Result doRequestExternalSwitching(IN const TargetSwitchState targetSwitchState);

      BmCoreMainController& _bmCoreMainController;

      void updateNumPendingBtsPairableRequests(const bool increment);

      void checkNumPendingBtsPairableRequests();

      LockForever _lock;
      bool _firstUpdate;

      TargetSwitchState _targetSwitchState;
      SwitchStatus _switchStatus;

      SwitchState _externalSwitchState;
      SwitchedOffReason _switchedOffReason;
      uint16_t _numPendingBtsPairableRequests;
   };
}

#endif // _LOCAL_PAIRABLE_MODE_SWITCH_PROP_HDL_H_
