/****************************************************************************
*FILE:         LinkQualityPropHdl.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  LinkQuality Property Handler
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef _LINK_QUALITY_PROP_HDL_H_
#define _LINK_QUALITY_PROP_HDL_H_

#include "LinkQuality.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class LinkQualityPropHdl
   {
   public:

      explicit LinkQualityPropHdl(BmCoreMainController& bmCoreMainController);

      ~LinkQualityPropHdl();

      void get(OUT LinkQuality& linkQuality);

      void set(IN const LinkQuality& linkQuality, IN const bool forcedUpdate = false);

   private:

      LinkQualityPropHdl(const LinkQualityPropHdl& other);

      LinkQualityPropHdl& operator=(const LinkQualityPropHdl& rhs);

      void onLinkQualityChanged(IN const LinkQuality& linkQuality);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      LinkQuality _linkQuality;
   };
}

#endif // _LINK_QUALITY_PROP_HDL_H_
