/**
 * @headerfile DeviceConnectionStatusListPropHdl.h
 * @brief This class implements the handler for DeviceConnectionStatusList
 * @date Jul 21, 2015
 * @author tnh5cob-tnh5cob
 */

#ifndef _DEVICE_CONNECTION_STATUS_LIST_PROP_HDL_H_
#define _DEVICE_CONNECTION_STATUS_LIST_PROP_HDL_H_

#include "BmAllTypes.h"
#include "DeviceConnectionStatusList.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class DeviceConnectionStatusListPropHdl
   {
   public:
      explicit DeviceConnectionStatusListPropHdl(BmCoreMainController& bmCoreMainController);

      ~DeviceConnectionStatusListPropHdl();

      void get(DeviceConnectionStatusList& deviceConnectionStatusList);

      void set(IN const DeviceConnectionStatusList& deviceConnectionStatusList, IN const bool forcedUpdate = false);

   private:

      DeviceConnectionStatusListPropHdl(const DeviceConnectionStatusListPropHdl& other);

      DeviceConnectionStatusListPropHdl& operator=(const DeviceConnectionStatusListPropHdl& rhs);

      void onDeviceConnectionStatusListChanged(IN const DeviceConnectionStatusList& deviceConnectionStatusList);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      DeviceConnectionStatusList _deviceConnectionStatusList;
      DeviceConnectionStatusList _previousDeviceConnectionStatusList;
   };
}

#endif // _DEVICE_CONNECTION_STATUS_LIST_PROP_HDL_H_

