#ifndef _BT_STATUS_SWITCH_PROP_HDL_H_
#define _BT_STATUS_SWITCH_PROP_HDL_H_

#include "SwitchStatus.h"
#include "BmAllTypesInternal.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class BtStatusSwitchPropHdl
   {
   public:

      explicit BtStatusSwitchPropHdl(BmCoreMainController& bmCoreMainController);

      ~BtStatusSwitchPropHdl();

      TargetSwitchState getTargetSwitchState(void) const;

      void get(OUT SwitchStatus& switchStatus);

      void setTargetSwitchState(IN const TargetSwitchState targetSwitchState,
            IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT, IN const bool delayBtOnRequest = false, IN const ActType act = 0u);

      void onExternalSwitchingResponse(IN const CcErrorInternal result);

      void onExternalSwitchStateUpdate(IN const SwitchState switchState, IN const SwitchedOffReason switchedOffReason);

   private:

      BtStatusSwitchPropHdl(const BtStatusSwitchPropHdl& other);

      BtStatusSwitchPropHdl& operator=(const BtStatusSwitchPropHdl& rhs);

      void doRespondSwitching(IN const Result result, IN const BmCoreIfMsgOrigin origin, IN const ActType act) const;

      void set(IN const SwitchStatus& switchStatus, IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT,
            IN const bool forcedUpdate = false);

      void onSwitchStatusChanged(IN const BmCoreIfMsgOrigin origin = BM_CORE_IF_MSG_ORIGIN_CLIENT);

      Result doRequestExternalSwitching(IN const TargetSwitchState targetSwitchState, IN const bool delayBtOnRequest = false) const;

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      TargetSwitchState _targetSwitchState;
      SwitchStatus _switchStatus;
   };
}

#endif /* _BT_STATUS_SWITCH_PROP_HDL_H_ */
