
#ifndef _BLOCK_STATUS_PROP_HDL_H_
#define _BLOCK_STATUS_PROP_HDL_H_

#include "BlockStatus.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class BlockStatusPropHdl
   {
   public:
      explicit BlockStatusPropHdl(BmCoreMainController& bmCoreMainController);

      ~BlockStatusPropHdl();

      void get(OUT BlockStatus& blockStatus);

      void set(IN const BlockStatus& blockStatus, IN const bool forcedUpdate = false);

      void getPrevious(OUT BlockStatus& previousBlockStatus);

   private:

      BlockStatusPropHdl(const BlockStatusPropHdl& other);

      BlockStatusPropHdl& operator=(const BlockStatusPropHdl& rhs);

      void onBlockStatusChanged(IN const BlockStatus& blockStatus);

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      BlockStatus _blockStatus;
      BlockStatus _previousBlockStatus;
   };
}

#endif /* _BLOCK_STATUS_PROP_HDL_H_ */
