#ifndef _AUTO_CONNECTION_STATUS_PROPHDL_H_
#define _AUTO_CONNECTION_STATUS_PROPHDL_H_

#include "AutoConnectionStatus.h"
#include "Lock.h"

namespace bmcore
{
   class BmCoreMainController;

   class AutoConnectionStatusPropHdl
   {
   public:
      explicit AutoConnectionStatusPropHdl(BmCoreMainController& bmCoreMainController);

      ~AutoConnectionStatusPropHdl();

      void get(AutoConnectionStatus& autoConnectionStatus);

      void set(IN const AutoConnectionStatus& autoConnectionStatus, IN const bool forcedUpdate = false);

   private:

      AutoConnectionStatusPropHdl(const AutoConnectionStatusPropHdl& other);

      AutoConnectionStatusPropHdl& operator=(const AutoConnectionStatusPropHdl& rhs);

      void onAutoConnectionStatusChanged();

      BmCoreMainController& _bmCoreMainController;

      LockForever _lock;
      bool _firstUpdate;

      AutoConnectionStatus _autoConnectionStatus;
   };
}

#endif // _AUTO_CONNECTION_STATUS_PROPHDL_H_
