/**
 * @file BtStackIfWblRequestIfWrapper.cpp
 *
 * @swcomponent BluetoothConnectionManagerCore
 *
 * @brief This file contains the definition of the class BtStackIfWblRequestIfWrapper
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmControllerModule
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_BMCONTROLLER
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BtStackIfWblRequestIfWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_BMCONTROLLER
#endif
#endif


#include "BtStackIfWblRequestIfWrapper.h"
#include "BtStackIfFactory.h"
#include "IBtStackIfWblRequest.h"
#include "FunctionTracer.h"
#include "FwAssert.h"

namespace bmcore
{
   BtStackIfWblRequestIfWrapper::BtStackIfWblRequestIfWrapper() : _btStackIfWblRequestIf(0)
   {
      ENTRY_INTERNAL

      ETG_TRACE_USR1(("BtStackIfWblRequestIfWrapper: is being created"));

      if (0 != _btStackIfWblRequestIf)
      {
         // already created
      }
      else
      {
         _btStackIfWblRequestIf = BtStackIfFactory::getInstance().getWblRequestIf();

         if (0 == _btStackIfWblRequestIf)
         {
            ETG_TRACE_ERRMEM(("BtStackIfWblRequestIfWrapper: _btStackIfWblRequestIf == 0"));
            // we should never reach this point here TODO: maybe FATAL ASSERT
            FW_NORMAL_ASSERT_ALWAYS();
         }
      }
   }

   BtStackIfWblRequestIfWrapper::~BtStackIfWblRequestIfWrapper()
   {
      ENTRY_INTERNAL

      ETG_TRACE_USR1(("~BtStackIfWblRequestIfWrapper: terminating BT Stack IF"));

      BTSErrorCode btsErrorCode = this->deInit();

      if (BTS_OK != btsErrorCode)
      {
         ETG_TRACE_ERRMEM(("~BtStackIfWblRequestIfWrapper: terminating BtStackIf failed (btsErrorCode = %d)",
               ETG_CENUM(BTSErrorCode, btsErrorCode)));
      }

      FW_NORMAL_ASSERT(BTS_OK == btsErrorCode);

      BtStackIfFactory::getInstance().destroyWblRequestIf(_btStackIfWblRequestIf);

      _btStackIfWblRequestIf = 0;
   }

   void BtStackIfWblRequestIfWrapper::registerCallback(IBtStackIfWblCallback* callback)
   {
      ETG_TRACE_USR1(("registerCallback"));

      _btStackIfWblRequestIf->registerCallback(callback);
   }

   BTSSessionHandle BtStackIfWblRequestIfWrapper::getSessionHandle(void) const
   {
      ETG_TRACE_USR1(("getSessionHandle"));

      return _btStackIfWblRequestIf->getSessionHandle();
   }

   BTSErrorCode BtStackIfWblRequestIfWrapper::init(IN const BTSLocalWblConfiguration& configuration) const
   {
      ETG_TRACE_USR1(("init"));

      return _btStackIfWblRequestIf->init(configuration);
   }

   BTSErrorCode BtStackIfWblRequestIfWrapper::deInit(void) const
   {
      ETG_TRACE_USR1(("deInit"));

      return _btStackIfWblRequestIf->deInit();
   }

   void BtStackIfWblRequestIfWrapper::setWblDummy(void)
   {
      ETG_TRACE_USR1(("setWblDummy"));

      return _btStackIfWblRequestIf->setWblDummy();
   }

   void BtStackIfWblRequestIfWrapper::allowWblCommunication(void)
   {
      ETG_TRACE_USR1(("allowWblCommunication"));

      return _btStackIfWblRequestIf->allowWblCommunication();
   }

   void BtStackIfWblRequestIfWrapper::blockWblCommunication(void)
   {
      ETG_TRACE_USR1(("blockWblCommunication"));

      return _btStackIfWblRequestIf->blockWblCommunication();
   }

   void BtStackIfWblRequestIfWrapper::getWblCommunicationStatus(void)
   {
      ETG_TRACE_USR1(("getWblCommunicationStatus"));

      return _btStackIfWblRequestIf->getWblCommunicationStatus();
   }

   void BtStackIfWblRequestIfWrapper::getWblLastIntendedMode(void)
   {
      ETG_TRACE_USR1(("getWblLastIntendedMode"));

      return _btStackIfWblRequestIf->getWblLastIntendedMode();
   }
}
