#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_INTERFACE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmCoreFactory.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_INTERFACE
#endif
#endif

#include "BmCoreFactory.h"
#include "BmCoreRequestIf.h"
#include "FunctionTracer.h"

namespace bmcore
{
   BmCoreFactory::BmCoreFactory() :
      localCreate(0),
      externCreate(1),
      _bmCoreRequestIfInstance(0),
      _connectionCreator(localCreate)
   {
      ETG_TRACE_USR1(("BmCoreFactory: being created"));
   }

   BmCoreFactory::~BmCoreFactory()
   {
      ETG_TRACE_USR1(("~BmCoreFactory: being destroyed"));

      _bmCoreRequestIfInstance = 0;
   }

   BmCoreFactory& BmCoreFactory::getInstance(void)
   {
      static BmCoreFactory bmCoreFactory;
      return bmCoreFactory;
   }

   IBmCoreRequestIf* BmCoreFactory::getBmCoreRequestIfInstance(void)
   {
      if (0 != _bmCoreRequestIfInstance)
      {
         // already created
      }
      else
      {
         _bmCoreRequestIfInstance = new BmInterface();
         _connectionCreator = localCreate;
      }

      return _bmCoreRequestIfInstance;
   }

   void BmCoreFactory::destroyBmCoreRequestIfInstance(void)
   {
      ETG_TRACE_USR1(("destroyBmCoreRequestIfInstance"));

      if ((0 != _bmCoreRequestIfInstance) && (localCreate == _connectionCreator))
      {
         ETG_TRACE_USR1(("destroyBmCoreRequestIfInstance(): destroying BM Core request IF instance"));

         delete _bmCoreRequestIfInstance;
         _bmCoreRequestIfInstance = 0;
      }
   }

   void BmCoreFactory::setBmCoreRequestIfInstanceForTesting(IN IBmCoreRequestIf* bmCoreRequestIfInstance)
   {
      ETG_TRACE_USR1(("setBmCoreRequestIfInstanceForTesting"));

      if (0 != _bmCoreRequestIfInstance)
      {
         // not allowed because already set => to be considered by unit test
      }
      else
      {
         _bmCoreRequestIfInstance = bmCoreRequestIfInstance;
         _connectionCreator = externCreate;
      }
   }
}
