/**
 * @file BmCoreCallbackIfWrapper.cpp
 *
 * @swcomponent BluetoothConnectionManagerCore
 *
 * @brief This file contains the definition of the class BmCoreCallbackIfWrapper
 *
 * @copyright (C) 2016 Robert Bosch GmbH.
 *            The reproduction, distribution and utilization of this file as
 *            well as the communication of its contents to others without express
 *            authorization is prohibited. Offenders will be held liable for the
 *            payment of damages. All rights reserved in the event of the grant
 *            of a patent, utility model or design.
 *
 * @details A detailed description is not yet available
 *
 * @ingroup BmControllerModule
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_INTERFACE
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/BmCoreCallbackIfWrapper.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_INTERFACE
#endif
#endif

#include "BmCoreCallbackIfWrapper.h"
#include "FunctionTracer.h"
#include "BmVarTrace.h"
#include "LocalSpm.h"


namespace bmcore
{
   BmCoreCallbackIfWrapper::BmCoreCallbackIfWrapper(ComponentId componentId, IBmCoreCallbackIf* bmCoreCallbackIf) :
      ILocalSpm(componentId), _bmCoreCallbackIf(bmCoreCallbackIf)
   {
      ENTRY_INTERNAL

      ETG_TRACE_USR1(("BmCoreCallbackIfWrapper: is being created"));
   };

   BmCoreCallbackIfWrapper::~BmCoreCallbackIfWrapper()
   {
      ENTRY_INTERNAL

      ETG_TRACE_USR1(("~BmCoreCallbackIfWrapper"));

      _bmCoreCallbackIf = 0;
   };

   void BmCoreCallbackIfWrapper::doUpdateConfiguration(INOUT BmCoreConfiguration& bmCoreConfiguration) const
   {
      ETG_TRACE_USR1(("updateConfiguration"));

      _bmCoreCallbackIf->updateConfiguration(bmCoreConfiguration);
   }

   void BmCoreCallbackIfWrapper::doStateChangeNormalResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("stateChangeNormalResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->stateChangeNormalResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doStateChangeOffResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("stateChangeOffResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->stateChangeOffResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnBtSystemStateChanged(IN const BtSystemState& btSystemState) const
   {
      ETG_TRACE_USR1(("onBtSystemStateChanged"));
      VARTRACE(btSystemState);

      _bmCoreCallbackIf->onBtSystemStateChanged(btSystemState);
   }

   void BmCoreCallbackIfWrapper::doSetProtocolUserAvailabilityResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("setProtocolUserAvailabilityResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->setProtocolUserAvailabilityResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doSetAutoConnectionTypeResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("setAutoConnectionTypeResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->setAutoConnectionTypeResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doSwitchLocalPairableModeResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("switchLocalPairableModeResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->switchLocalPairableModeResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doOnLocalPairableModeChanged(IN const SwitchStatus& localPairableMode) const
   {
      ETG_TRACE_USR1(("onLocalPairableModeChanged"));
      VARTRACE(localPairableMode);

      _bmCoreCallbackIf->onLocalPairableModeChanged(localPairableMode);
   }

   void BmCoreCallbackIfWrapper::doSwitchLocalConnectableModeResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("switchLocalConnectableModeResponse: bmResult = %d, act = %u",
            ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->switchLocalConnectableModeResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnLocalConnectableModeChanged(IN const SwitchStatus& localConnectableMode) const
   {
      ETG_TRACE_USR1(("onLocalConnectableModeChanged"));
      VARTRACE(localConnectableMode);

      _bmCoreCallbackIf->onLocalConnectableModeChanged(localConnectableMode);
   }

   void BmCoreCallbackIfWrapper::doSwitchDiscoveryStatusResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("switchDiscoveryStatusResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->switchDiscoveryStatusResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnDiscoveryStatusChanged(IN const SwitchStatus& discoveryStatus) const
   {
      ETG_TRACE_USR1(("onDiscoveryStatusChanged"));
      VARTRACE(discoveryStatus);

      _bmCoreCallbackIf->onDiscoveryStatusChanged(discoveryStatus);
   }

   void BmCoreCallbackIfWrapper::doOnDiscoveredDeviceChanged(IN const BdAddress& bdAddress, IN const BdName& btDeviceName) const
   {
      ETG_TRACE_USR1(("onDiscoveredDeviceChanged"));

      _bmCoreCallbackIf->onDiscoveredDeviceChanged(bdAddress, btDeviceName);
   }

   void BmCoreCallbackIfWrapper::doOnDiscoveredDeviceListChanged(IN const DiscoveredDeviceList& discoveredDeviceList) const
   {
      ETG_TRACE_USR1(("onDiscoveredDeviceListChanged"));
      VARTRACE(discoveredDeviceList);

      _bmCoreCallbackIf->onDiscoveredDeviceListChanged(discoveredDeviceList);
   }

   void BmCoreCallbackIfWrapper::doSwitchBtStatusResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("switchBtStatusResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->switchBtStatusResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnBtStatusChanged(IN const SwitchStatus& bluetoothStatus) const
   {
      ETG_TRACE_USR1(("onBtStatusChanged"));
      VARTRACE(bluetoothStatus);

      _bmCoreCallbackIf->onBtStatusChanged(bluetoothStatus);
   }

   void BmCoreCallbackIfWrapper::doOnBtLocalFriendlyNameChanged(IN const LocalFriendlyName& btLocalFriendlyName) const
   {
      ETG_TRACE_USR1(("onBtLocalFriendlyNameChanged"));
      VARTRACE(btLocalFriendlyName);

      _bmCoreCallbackIf->onBtLocalFriendlyNameChanged(btLocalFriendlyName);
   }

   void BmCoreCallbackIfWrapper::doOnBtLocalInfoChanged(IN const LocalInfo& btLocalInfo) const
   {
      ETG_TRACE_USR1(("onBtLocalInfoChanged"));
      VARTRACE(btLocalInfo);

      _bmCoreCallbackIf->onBtLocalInfoChanged(btLocalInfo);
   }

   void BmCoreCallbackIfWrapper::doOnPairingStatusChanged(IN const PairingStatus& btPairingStatus) const
   {
      ETG_TRACE_USR1(("onPairingStatusChanged"));
      VARTRACE(btPairingStatus);

      _bmCoreCallbackIf->onPairingStatusChanged(btPairingStatus);
   }

   void BmCoreCallbackIfWrapper::doOnPairingPinChanged(IN const PairingPin& pairingPin) const
   {
      ETG_TRACE_USR1(("onPairingPinChanged"));
      VARTRACE(pairingPin);

      _bmCoreCallbackIf->onPairingPinChanged(pairingPin);
   }

   void BmCoreCallbackIfWrapper::doRejectPairingRequestResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("rejectPairingRequestResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->rejectPairingRequestResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doAcceptPairingRequestResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("acceptPairingRequestResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->acceptPairingRequestResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doSetPairingPinResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("setPairingPinResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->setPairingPinResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doAddOobPairedDeviceResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("addOobPairedDeviceResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->addOobPairedDeviceResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doOnPairedDeviceListChanged(IN const PairedDeviceList& pairedDeviceList) const
   {
      ETG_TRACE_USR1(("onPairedDeviceListChanged"));
      VARTRACE(pairedDeviceList);

      _bmCoreCallbackIf->onPairedDeviceListChanged(pairedDeviceList);
   }

   void BmCoreCallbackIfWrapper::doOnDeviceConnectionStatusListChanged(IN const DeviceConnectionStatusList& deviceConnectionStatusList) const
   {
      ETG_TRACE_USR1(("onDeviceConnectionStatusListChanged"));
      VARTRACE(deviceConnectionStatusList);

      _bmCoreCallbackIf->onDeviceConnectionStatusListChanged(deviceConnectionStatusList);
   }

   void BmCoreCallbackIfWrapper::doCancelPairingResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("cancelPairingResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->cancelPairingResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doStartPairingResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("startPairingResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->startPairingResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnAutoConnectionStatusChanged(IN const AutoConnectionStatus& autoConnectionStatus) const
   {
      ETG_TRACE_USR1(("onAutoConnectionStatusChanged"));
      VARTRACE(autoConnectionStatus);

      _bmCoreCallbackIf->onAutoConnectionStatusChanged(autoConnectionStatus);
   }

   void BmCoreCallbackIfWrapper::doConnectDeviceResponse(IN const DeviceId deviceHandle, IN const BmResult bmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("connectDeviceResponse: deviceHandle = %d, bmResult = %d, act = %u", deviceHandle,
            ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->connectDeviceResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doDisconnectDeviceResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("disconnectDeviceResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->disconnectDeviceResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doDeleteDeviceResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("deleteDeviceResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->deleteDeviceResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doBlockDeviceResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("blockDeviceResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->blockDeviceResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doUnblockDeviceResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("unblockDeviceResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->unblockDeviceResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doConnectProfilesResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("connectProfilesResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->connectProfilesResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doDisconnectProfilesResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("disconnectProfilesResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->disconnectProfilesResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doStoreDeviceRingtoneIdInDbResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("storeDeviceRingtoneIdInDbResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->storeDeviceRingtoneIdInDbResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doReadDeviceRingtoneIdFromDbResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("readDeviceRingtoneIdFromDbResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->readDeviceRingtoneIdFromDbResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doStoreSystemWideRingtoneIdInDbResponse(IN const BmResult bmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("storeSystemWideRingtoneIdInDbResponse: bmResult = %d, act = %u",
            ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->storeSystemWideRingtoneIdInDbResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doReadSystemWideRingtoneIdFromDbResponse(IN const BmResult bmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("readSystemWideRingtoneIdFromDbResponse: bmResult = %d, act = %u",
            ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->readSystemWideRingtoneIdFromDbResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doBlockProfilesResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("blockProfilesResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->blockProfilesResponse(deviceHandle, bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doUnblockProfilesResponse(IN const DeviceId deviceHandle,
         IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("unblockProfilesResponse: deviceHandle = %d, bmResult = %d, act = %u",
            deviceHandle, ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->unblockProfilesResponse(deviceHandle, bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnBlockStatusChanged(IN const BlockStatus& blockStatus) const
   {
      ETG_TRACE_USR1(("onBlockStatusChanged"));
      VARTRACE(blockStatus);

      _bmCoreCallbackIf->onBlockStatusChanged(blockStatus);
   }

   void BmCoreCallbackIfWrapper::doSetFavoriteResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("setFavoriteResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->setFavoriteResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doClearFavoriteResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("clearFavoriteResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->clearFavoriteResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doOnAutoConnectionTypeChanged(IN const AutoConnectionType& autoConnectionType) const
   {
      ETG_TRACE_USR1(("onAutoConnectionTypeChanged"));
      VARTRACE(autoConnectionType);

      _bmCoreCallbackIf->onAutoConnectionTypeChanged(autoConnectionType);
   }

   void BmCoreCallbackIfWrapper::doStartAutoConnectSequenceResponse(IN const BmResult bmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("startAutoConnectSequenceResponse: bmResult = %d, act = %u",
            ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->startAutoConnectSequenceResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doStopAutoConnectSequenceResponse(IN const BmResult bmResult,
         IN const ActType act) const
   {
      ETG_TRACE_USR1(("stopAutoConnectSequenceResponse: bmResult = %d, act = %u",
            ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->stopAutoConnectSequenceResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnBmConfigDataChanged(IN const BmConfigData& bmConfigData) const
   {
      ETG_TRACE_USR1(("onBmConfigDataChanged"));
      VARTRACE(bmConfigData);

      _bmCoreCallbackIf->onBmConfigDataChanged(bmConfigData);
   }

   void BmCoreCallbackIfWrapper::doOnBmServiceAvailabilityChanged(IN const BmServiceAvailability& bmServiceAvailability) const
   {
      ETG_TRACE_USR1(("onBmServiceAvailabilityChanged"));
      VARTRACE(bmServiceAvailability);

      _bmCoreCallbackIf->onBmServiceAvailabilityChanged(bmServiceAvailability);
   }

   void BmCoreCallbackIfWrapper::doOnLinkQualityChanged(IN const LinkQuality& linkQuality) const
   {
      ETG_TRACE_USR1(("onLinkQualityChanged"));
      VARTRACE(linkQuality);

      _bmCoreCallbackIf->onLinkQualityChanged(linkQuality);
   }

   void BmCoreCallbackIfWrapper::doUpdateLinkQualityResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("updateLinkQualityResponse: bmResult = %d, act = %u",
            ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->updateLinkQualityResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doSetBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("setBtLimitationModeResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->setBtLimitationModeResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doReplaceBtLimitationModeResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("replaceBtLimitationModeResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->replaceBtLimitationModeResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doOnBtLimitationModeChanged(IN const BtLimitationMode& btLimitationMode) const
   {
      ETG_TRACE_USR1(("onBtLimitationModeChanged"));
      VARTRACE(btLimitationMode);

      _bmCoreCallbackIf->onBtLimitationModeChanged(btLimitationMode);
   }

   void BmCoreCallbackIfWrapper::doOnUserDecisionRequiredSignal(IN const IssueInfoList& issueInfoList) const
   {
      ETG_TRACE_USR1(("onUserDecisionRequiredSignal"));
      VARTRACE(issueInfoList);

      _bmCoreCallbackIf->onUserDecisionRequiredSignal(issueInfoList);
   }

   void BmCoreCallbackIfWrapper::doNotifyUserDecisionResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("notifyUserDecisionResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->notifyUserDecisionResponse(bmResult, act);
   }

   void BmCoreCallbackIfWrapper::doResetToDefaultResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("resetToDefaultResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->resetToDefaultResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnResetToDefaultStatusChanged(IN const ResetToDefaultStatus& status) const
   {
      ETG_TRACE_USR1(("onResetToDefaultStatusChanged"));
      VARTRACE(status);

      _bmCoreCallbackIf->onResetToDefaultStatusChanged(status);
   }

   void BmCoreCallbackIfWrapper::doSwitchTestModeResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("switchTestModeResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->switchTestModeResponse(bmResult);
   }

   void BmCoreCallbackIfWrapper::doOnTestModeChanged(IN const SwitchStatus& testMode) const
   {
      ETG_TRACE_USR1(("onTestModeChanged"));
      VARTRACE(testMode);

      _bmCoreCallbackIf->onTestModeChanged(testMode);
   }

   void BmCoreCallbackIfWrapper::doRequestTestModeLinkQualityResponse(IN const BmResult bmResult,
         IN const LinkQualityInfo& linkQualityInfo, IN const ActType act) const
   {
      ETG_TRACE_USR1(("requestTestModeLinkQualityResponse: bmResult = %d, act = %u",
            ETG_CENUM(BmResult, bmResult), act));
      VARTRACE(linkQualityInfo);

      _bmCoreCallbackIf->requestTestModeLinkQualityResponse(bmResult, linkQualityInfo);
   }

   void BmCoreCallbackIfWrapper::doOnLinkQualityTestModeChanged(IN const TestModeLinkQuality& linkQuality) const
   {
      ETG_TRACE_USR1(("onLinkQualityTestModeChanged"));
      VARTRACE(linkQuality);

      _bmCoreCallbackIf->onLinkQualityTestModeChanged(linkQuality);
   }

   void BmCoreCallbackIfWrapper::doSetPrimaryHfpDeviceResponse(IN const BmResult bmResult) const
   {
      ETG_TRACE_USR1(("setPrimaryHfpDeviceResponse: bmResult = %d", ETG_CENUM(BmResult, bmResult)));

      _bmCoreCallbackIf->setPrimaryHfpDeviceResponse(bmResult);
   }


   void BmCoreCallbackIfWrapper::doStartServiceSearchResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("startServiceSearchResponse: bmResult = %d , act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->startServiceSearchResponse(bmResult,act);
   }

   void BmCoreCallbackIfWrapper::doStopServiceSearchResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("stopServiceSearchResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->stopServiceSearchResponse(bmResult,act);
   }

   void BmCoreCallbackIfWrapper::doSwitchMultiHFPSupportResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("switchMultiHFPSupportResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->switchMultiHFPSupportResponse(bmResult,act);
   }

   void BmCoreCallbackIfWrapper::doOnBtProfileUsageInfoChanged(IN const ProfileUsageList& btProfileUsageList) const
   {
      ETG_TRACE_USR1(("onBtProfileUsageInfoChanged"));
      VARTRACE(btProfileUsageList);

      _bmCoreCallbackIf->onBtProfileUsageInfoChanged(btProfileUsageList);
   }

   void BmCoreCallbackIfWrapper::doOnSetBtProfileUsageInfoResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("onSetBtProfileUsageInfoResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->setBtProfileUsageInfoResponse(bmResult, act);
   }
   
   void BmCoreCallbackIfWrapper::doOnMultiHFPSupportStatusChanged(IN const SwitchStatus& multiHFPSupportStatus) const
   {
      ETG_TRACE_USR1(("onMultiHFPSupportStatusChanged"));
      VARTRACE(multiHFPSupportStatus);

      _bmCoreCallbackIf->onMultiHFPSupportStatusChanged(multiHFPSupportStatus);
   }

   void BmCoreCallbackIfWrapper::doSetDeviceUsagePreferenceResponse(IN const BmResult bmResult, IN const ActType act) const
   {
      ETG_TRACE_USR1(("setDeviceUsagePreferenceResponse: bmResult = %d, act = %u", ETG_CENUM(BmResult, bmResult), act));

      _bmCoreCallbackIf->setDeviceUsagePreferenceResponse(bmResult,act);
   }

   void BmCoreCallbackIfWrapper::create()
   {
      ETG_TRACE_USR1(("create"));

      createDone(0);
   }

   int BmCoreCallbackIfWrapper::init(InitReason reason)
   {
      ETG_TRACE_USR1(("init: reason = %d", ETG_CENUM(InitReason, reason)));

      return initDone(0);
   }

   int BmCoreCallbackIfWrapper::run()
   {
      ETG_TRACE_USR1(("run"));

      return runDone(0);
   }

   int BmCoreCallbackIfWrapper::stop()
   {
      ETG_TRACE_USR1(("stop"));

      return stopDone(0);
   }

   int BmCoreCallbackIfWrapper::done()
   {
      ETG_TRACE_USR1(("done"));

      return doneDone(0);
   }
}
