#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/WifiHealthinessIndicatorInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "WifiHealthinessIndicatorInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   WifiHealthinessIndicatorInfo::WifiHealthinessIndicatorInfo() :
      _wifiHealthinessIndicatorThresholdValue(0), _connectionPageTimeoutMilliSeconds(0)
   {
      ENTRY_INTERNAL
   }

   WifiHealthinessIndicatorInfo::WifiHealthinessIndicatorInfo(const uint8_t& wifiHealthinessIndicatorThresholdValue, const PageTimeout connectionPageTimeoutMilliSeconds) :
         _wifiHealthinessIndicatorThresholdValue(wifiHealthinessIndicatorThresholdValue), _connectionPageTimeoutMilliSeconds(connectionPageTimeoutMilliSeconds)
   {
      ENTRY_INTERNAL
   }

   WifiHealthinessIndicatorInfo::WifiHealthinessIndicatorInfo(const WifiHealthinessIndicatorInfo& other) :
      _wifiHealthinessIndicatorThresholdValue(other._wifiHealthinessIndicatorThresholdValue), _connectionPageTimeoutMilliSeconds(other._connectionPageTimeoutMilliSeconds)
   {
      ENTRY_INTERNAL
   }

   WifiHealthinessIndicatorInfo::~WifiHealthinessIndicatorInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(WifiHealthinessIndicatorInfo& first, WifiHealthinessIndicatorInfo& second)
   {
      using std::swap;

      swap(first._wifiHealthinessIndicatorThresholdValue, second._wifiHealthinessIndicatorThresholdValue);
      swap(first._connectionPageTimeoutMilliSeconds, second._connectionPageTimeoutMilliSeconds);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   WifiHealthinessIndicatorInfo& WifiHealthinessIndicatorInfo::operator=(WifiHealthinessIndicatorInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool WifiHealthinessIndicatorInfo::operator==(const WifiHealthinessIndicatorInfo& rhs) const
   {
      return ((this->_wifiHealthinessIndicatorThresholdValue == rhs._wifiHealthinessIndicatorThresholdValue)
            && (this->_connectionPageTimeoutMilliSeconds == rhs._connectionPageTimeoutMilliSeconds));
   }
}
