
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/UserDecisionInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "UserDecisionInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   UserDecisionInfo::UserDecisionInfo() :
          _conflictTrigger(BM_CONFLICT_TRIGGER_NONE), _userDecision(BM_USER_DECISION_NONE)
   {
      ENTRY_INTERNAL
   }

   UserDecisionInfo::UserDecisionInfo(IN const ConflictTrigger conflictTrigger, IN const UserDecision userDecision) :
          _conflictTrigger(conflictTrigger), _userDecision(userDecision)
   {
      ENTRY_INTERNAL
   }

   UserDecisionInfo::UserDecisionInfo(const UserDecisionInfo& other) :
         _conflictTrigger(other._conflictTrigger), _userDecision(other._userDecision)
   {
      ENTRY_INTERNAL
   }

   UserDecisionInfo::~UserDecisionInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(UserDecisionInfo& first, UserDecisionInfo& second)
   {
      using std::swap;

      swap(first._conflictTrigger, second._conflictTrigger);
      swap(first._userDecision, second._userDecision);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   UserDecisionInfo& UserDecisionInfo::operator=(UserDecisionInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool UserDecisionInfo::operator==(const UserDecisionInfo& rhs) const
   {
	   return ((this->_conflictTrigger == rhs._conflictTrigger)
			   && (this->_userDecision == rhs._userDecision));
   }

   bool UserDecisionInfo::operator!=(const UserDecisionInfo& rhs) const
   {
	   return ((this->_conflictTrigger == rhs._conflictTrigger)
			   && (this->_userDecision == rhs._userDecision));
   }
}
