#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SwitchStatus.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "SwitchStatus.h"
#include "FunctionTracer.h"

namespace bmcore
{
   SwitchStatus::SwitchStatus() :
          _switchState(SWITCH_STATE_SWITCHED_OFF), _switchedOffReason(SWITCHED_OFF_REASON_CLIENT)
   {
      ENTRY_INTERNAL
   }

   SwitchStatus::SwitchStatus(const SwitchState& switchState, const SwitchedOffReason& switchedOffReason) :
        _switchState(switchState), _switchedOffReason(switchedOffReason)
   {
      ENTRY_INTERNAL
   }

   SwitchStatus::SwitchStatus(const SwitchStatus& other) :
        _switchState(other._switchState), _switchedOffReason(other._switchedOffReason)
   {
      ENTRY_INTERNAL
   }

   SwitchStatus::~SwitchStatus()
   {
      ENTRY_INTERNAL
   }

   void swap(SwitchStatus& first, SwitchStatus& second)
   {
      using std::swap;

      swap(first._switchState, second._switchState);
      swap(first._switchedOffReason, second._switchedOffReason);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SwitchStatus& SwitchStatus::operator=(SwitchStatus other)
   {
      swap(*this, other);

      return *this;
   }

   bool SwitchStatus::operator==(const SwitchStatus& rhs) const
   {
	   return ((this->_switchState == rhs._switchState)
			   && (this->_switchedOffReason == rhs._switchedOffReason));
   }

   bool SwitchStatus::operator!=(const SwitchStatus& rhs) const
   {
	   return (!((this->_switchState == rhs._switchState)
			   && (this->_switchedOffReason == rhs._switchedOffReason)));
   }
} // namespace cc
