#ifndef _SPP_SERVICE_INFO_H_
#define _SPP_SERVICE_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "BaseTypes.h"
#include <list>

namespace bmcore
{
   class SppServiceInfo
   {
   public:
      SppServiceInfo();

      SppServiceInfo(const uint8_t& maxNumInstances, const ServiceName& serviceName, const Uuid& localUuid, const Uuid& remoteUuid);

      SppServiceInfo(const SppServiceInfo& other);

      virtual ~SppServiceInfo();

      friend void swap(SppServiceInfo& first, SppServiceInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      SppServiceInfo& operator=(SppServiceInfo other);

      bool operator==(const SppServiceInfo& rhs) const;

      uint8_t _maxNumInstances;
      ServiceName _serviceName;
      Uuid _localUuid;
      Uuid _remoteUuid;
   };

   typedef std::list<SppServiceInfo> SppServiceInformation;
}

#endif // _SPP_SERVICE_INFO_H_
