#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/SppServiceInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "SppServiceInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   SppServiceInfo::SppServiceInfo() :
      _maxNumInstances(0), _serviceName(""), _localUuid(""), _remoteUuid("")
   {
      ENTRY_INTERNAL
   }

   SppServiceInfo::SppServiceInfo(const uint8_t& maxNumInstances, const ServiceName& serviceName, const Uuid& localUuid, const Uuid& remoteUuid) :
      _maxNumInstances(maxNumInstances), _serviceName(serviceName), _localUuid(localUuid), _remoteUuid(remoteUuid)
   {
      ENTRY_INTERNAL
   }

   SppServiceInfo::SppServiceInfo(const SppServiceInfo& other) :
      _maxNumInstances(other._maxNumInstances), _serviceName(other._serviceName), _localUuid(other._localUuid), _remoteUuid(other._remoteUuid)
   {
      ENTRY_INTERNAL
   }

   SppServiceInfo::~SppServiceInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(SppServiceInfo& first, SppServiceInfo& second)
   {
      using std::swap;

      swap(first._maxNumInstances, second._maxNumInstances);
      swap(first._serviceName, second._serviceName);
      swap(first._localUuid, second._localUuid);
      swap(first._remoteUuid, second._remoteUuid);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   SppServiceInfo& SppServiceInfo::operator=(SppServiceInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool SppServiceInfo::operator==(const SppServiceInfo& rhs) const
   {
      return ((this->_maxNumInstances == rhs._maxNumInstances)
            && (this->_serviceName == rhs._serviceName)
            && (this->_localUuid == rhs._localUuid)
            && (this->_remoteUuid == rhs._remoteUuid));
   }
}
