/****************************************************************************
*FILE:         ResetToDefaultStatus.h 
*SW-COMPONENT: bmcore
*DESCRIPTION:  ResetToDefaultStatus Property
*COPYRIGHT:    (c) 2015 Robert Bosch Car Multimedia GmbH
****************************************************************************/

#ifndef RESETTODEFAULTSTATUS_H_
#define RESETTODEFAULTSTATUS_H_

#include "BmInterfaceTypesInternal.h"

namespace bmcore
{
   class ResetToDefaultStatus 
   {
   public:

      ResetToDefaultStatus();

      ResetToDefaultStatus(IN const ResetToDefaultState resetState, IN const ResetToDefaultResult resetResult);

      ResetToDefaultStatus(const ResetToDefaultStatus& other);

      ~ResetToDefaultStatus();

      friend void swap(ResetToDefaultStatus& first, ResetToDefaultStatus& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ResetToDefaultStatus& operator=(ResetToDefaultStatus other);

      bool operator==(const ResetToDefaultStatus& rhs) const;

      bool operator!=(const ResetToDefaultStatus& rhs) const;

      ResetToDefaultState  _resetState;
      ResetToDefaultResult _resetResult;

   private:
   };

} // namespace bmcore

#endif /* RESETTODEFAULTSTATUS_H_ */
