#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/RemoteDeviceInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "RemoteDeviceInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   RemoteDeviceInfo::RemoteDeviceInfo():
         _deviceBaseInfo(),
         _linkKey(""),
         _protocolConnectionInfo(),
         _sppConnectionInfo()
   {
      ENTRY_INTERNAL
   }

   RemoteDeviceInfo::RemoteDeviceInfo(const DeviceBaseInfo& deviceBaseInfo, const LinkKey& linkKey,
         const ProtocolConnectionInfoMap& protocolConnectionInfo, const SppConnectionInfoMap& sppConnectionInfo):
         _deviceBaseInfo(deviceBaseInfo),
         _linkKey(linkKey),
         _protocolConnectionInfo(protocolConnectionInfo),
         _sppConnectionInfo(sppConnectionInfo)
   {
      ENTRY_INTERNAL
   }

   RemoteDeviceInfo::RemoteDeviceInfo(const RemoteDeviceInfo& other):
         _deviceBaseInfo(other._deviceBaseInfo),
         _linkKey(other._linkKey),
         _protocolConnectionInfo(other._protocolConnectionInfo),
         _sppConnectionInfo(other._sppConnectionInfo)
   {
      ENTRY_INTERNAL
   }

   RemoteDeviceInfo::~RemoteDeviceInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(RemoteDeviceInfo& first, RemoteDeviceInfo& second)
   {
      using std::swap;

      swap(first._deviceBaseInfo, second._deviceBaseInfo);
      swap(first._linkKey, second._linkKey);
      swap(first._protocolConnectionInfo, second._protocolConnectionInfo);
      swap(first._sppConnectionInfo, second._sppConnectionInfo);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   RemoteDeviceInfo& RemoteDeviceInfo::operator=(RemoteDeviceInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool RemoteDeviceInfo::operator==(const RemoteDeviceInfo& rhs) const
   {
	   return ((this->_deviceBaseInfo == rhs._deviceBaseInfo)
			   &&(this->_linkKey == rhs._linkKey)
			   &&(this->_protocolConnectionInfo == rhs._protocolConnectionInfo)
			   &&(this->_sppConnectionInfo == rhs._sppConnectionInfo));
   }

   bool RemoteDeviceInfo::operator!=(const RemoteDeviceInfo& rhs) const
   {
	   return (!((this->_deviceBaseInfo == rhs._deviceBaseInfo)
			   &&(this->_linkKey == rhs._linkKey)
			   &&(this->_protocolConnectionInfo == rhs._protocolConnectionInfo)
			   &&(this->_sppConnectionInfo == rhs._sppConnectionInfo)));
   }
}
