#ifndef _PROTOCOL_SUPPORT_INFO_H_
#define _PROTOCOL_SUPPORT_INFO_H_

#include "BmInterfaceTypesInternal.h"
#include "BaseTypes.h"
#include <map>

namespace bmcore
{
   class ProtocolSupportInfo
   {
   public:
      ProtocolSupportInfo();

      ProtocolSupportInfo(const ProtocolName& name, const ProtocolVersion version, const uint8_t maxNumInstances,
            const ProtocolDependencyLevel dependencyLevel, const MasterProtocolsSelector masterProtocolsSelector,
            const bool usedForDeviceConnection);

      ProtocolSupportInfo(const ProtocolSupportInfo& other);

      virtual ~ProtocolSupportInfo();

      friend void swap(ProtocolSupportInfo& first, ProtocolSupportInfo& second);

      //lint -e{1720} suppress "assignment operator has non-const parameter", see copy-and-swap idiom
      ProtocolSupportInfo& operator=(ProtocolSupportInfo other);

      bool operator==(const ProtocolSupportInfo& rhs) const;

      ProtocolName _name;
      ProtocolVersion _version;
      uint8_t _maxNumInstances;
      ProtocolDependencyLevel _dependencyLevel;
      MasterProtocolsSelector _masterProtocolsSelector;
      bool _usedForDeviceConnection;
   };

   typedef std::map<ProtocolId, ProtocolSupportInfo> ProtocolSupportInformation;
}

#endif // _PROTOCOL_SUPPORT_INFO_H_
