#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ProtocolSupportInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "ProtocolSupportInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   ProtocolSupportInfo::ProtocolSupportInfo() :
         _name(""), _version(0), _maxNumInstances(0), _dependencyLevel(BM_PROTOCOL_DEPENDENCY_LEVEL_STAND_ALONE),
         _masterProtocolsSelector(BM_MASTER_PROTOCOLS_SELECTOR_NONE), _usedForDeviceConnection(false)
   {
      ENTRY_INTERNAL
   }

   ProtocolSupportInfo::ProtocolSupportInfo(const ProtocolName& name, const ProtocolVersion version,
         const uint8_t maxNumInstances, const ProtocolDependencyLevel dependencyLevel, const MasterProtocolsSelector masterProtocolsSelector,
         const bool usedForDeviceConnection) :
         _name(name), _version(version), _maxNumInstances(maxNumInstances), _dependencyLevel(dependencyLevel),
         _masterProtocolsSelector(masterProtocolsSelector), _usedForDeviceConnection(usedForDeviceConnection)
   {
      ENTRY_INTERNAL
   }

   ProtocolSupportInfo::ProtocolSupportInfo(const ProtocolSupportInfo& other) :
         _name(other._name), _version(other._version), _maxNumInstances(other._maxNumInstances),
         _dependencyLevel(other._dependencyLevel), _masterProtocolsSelector(other._masterProtocolsSelector),
         _usedForDeviceConnection(other._usedForDeviceConnection)
   {
      ENTRY_INTERNAL
   }

   ProtocolSupportInfo::~ProtocolSupportInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(ProtocolSupportInfo& first, ProtocolSupportInfo& second)
   {
      using std::swap;

      swap(first._name, second._name);
      swap(first._version, second._version);
      swap(first._maxNumInstances, second._maxNumInstances);
      swap(first._dependencyLevel, second._dependencyLevel);
      swap(first._masterProtocolsSelector, second._masterProtocolsSelector);
      swap(first._usedForDeviceConnection, second._usedForDeviceConnection);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ProtocolSupportInfo& ProtocolSupportInfo::operator=(ProtocolSupportInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool ProtocolSupportInfo::operator==(const ProtocolSupportInfo& rhs) const
   {
      return ((this->_name == rhs._name)
            && (this->_version == rhs._version)
            && (this->_maxNumInstances == rhs._maxNumInstances)
            && (this->_dependencyLevel == rhs._dependencyLevel)
            && (this->_masterProtocolsSelector == rhs._masterProtocolsSelector)
            && (this->_usedForDeviceConnection == rhs._usedForDeviceConnection));
   }
}
