#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ProtocolConnectionInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "ProtocolConnectionInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
   ProtocolConnectionInfo::ProtocolConnectionInfo() :
         _connectionStatus(BM_CONNECTION_STATUS_DISCONNECTED), _disconnectedReason(BM_DISCONNECTED_REASON_NORMAL_LOSS_LOCAL),
         _rfcommDevicePath(""), _primary(0)
   {
      ENTRY_INTERNAL
   }

   ProtocolConnectionInfo::ProtocolConnectionInfo(const ConnectionStatus& connectionStatus, const DisconnectedReason& disconnectedReason,
         const RfcommDevicePath& rfcommDevicePath, const unsigned int primary) :
         _connectionStatus(connectionStatus), _disconnectedReason(disconnectedReason), _rfcommDevicePath(rfcommDevicePath), _primary(primary)
   {
      ENTRY_INTERNAL
   }

   ProtocolConnectionInfo::ProtocolConnectionInfo(const ProtocolConnectionInfo& other) :
      _connectionStatus(other._connectionStatus), _disconnectedReason(other._disconnectedReason),
      _rfcommDevicePath(other._rfcommDevicePath), _primary(other._primary)
   {
      ENTRY_INTERNAL
   }

   ProtocolConnectionInfo::~ProtocolConnectionInfo()
   {
      ENTRY_INTERNAL
   }

   void swap(ProtocolConnectionInfo& first, ProtocolConnectionInfo& second)
   {
      using std::swap;

      swap(first._connectionStatus, second._connectionStatus);
      swap(first._disconnectedReason, second._disconnectedReason);
      swap(first._rfcommDevicePath, second._rfcommDevicePath);
      swap(first._primary, second._primary);
   }

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ProtocolConnectionInfo& ProtocolConnectionInfo::operator=(ProtocolConnectionInfo other)
   {
      swap(*this, other);

      return *this;
   }

   bool ProtocolConnectionInfo::operator==(const ProtocolConnectionInfo& rhs) const
   {
      return ((this->_connectionStatus == rhs._connectionStatus)
            && (this->_disconnectedReason == rhs._disconnectedReason)
            && (this->_rfcommDevicePath == rhs._rfcommDevicePath)
            && (this->_primary == rhs._primary));
   }

   bool ProtocolConnectionInfo::operator!=(const ProtocolConnectionInfo& rhs) const
   {
      return (!((this->_connectionStatus == rhs._connectionStatus)
            && (this->_disconnectedReason == rhs._disconnectedReason)
            && (this->_rfcommDevicePath == rhs._rfcommDevicePath)
            && (this->_primary == rhs._primary)));
   }
}
