#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_fw.h"

#include "BmTraceClasses.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#ifdef VARIANT_S_FTR_ENABLE_FW_ETG_USAGE
#include "trcGenProj/Header/ProfileUsageInfo.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_BM_CORE_APPLICATION
#endif
#endif

#include "ProfileUsageInfo.h"
#include "FunctionTracer.h"

namespace bmcore
{
	ProfileUsageInfo::ProfileUsageInfo() :_deviceHandle(0u), _protocol(),
			_ProfileUsageType(BT_PROFILE_USAGE_NONE), _InUse(false)
	{
		ENTRY_INTERNAL
	}

	ProfileUsageInfo::ProfileUsageInfo(const DeviceId deviceHandle, const Protocol& protocol,
			   const BTProfileUsageType ProfileUsageType, const bool InUseInfo) :
			   _deviceHandle(deviceHandle), _protocol(protocol), _ProfileUsageType(ProfileUsageType), _InUse(InUseInfo)
	{
		ENTRY_INTERNAL
	}

	ProfileUsageInfo::ProfileUsageInfo(const ProfileUsageInfo& ProfileInUse) :
		_deviceHandle(ProfileInUse._deviceHandle), _protocol(ProfileInUse._protocol),
		_ProfileUsageType(ProfileInUse._ProfileUsageType),_InUse(ProfileInUse._InUse)
    {
    	ENTRY_INTERNAL
    }

	ProfileUsageInfo::~ProfileUsageInfo()
    {
		ENTRY_INTERNAL
    }

	void swap(ProfileUsageInfo& first, ProfileUsageInfo& second)
	{
	      using std::swap;

	      swap(first._deviceHandle, second._deviceHandle);
	      swap(first._protocol, second._protocol);
	      swap(first._ProfileUsageType, second._ProfileUsageType);
	      swap(first._InUse, second._InUse);
	}

   //lint -e{1529} suppress "assignment operator not first checking for assignment to this", see copy-and-swap idiom
   ProfileUsageInfo& ProfileUsageInfo::operator=(ProfileUsageInfo rhs)
   {
	      swap(*this, rhs);
	      return *this;
   }

   bool ProfileUsageInfo::operator==(const ProfileUsageInfo& rhs) const
   {
      return ((this->_deviceHandle == rhs._deviceHandle)
            && (this->_protocol == rhs._protocol)
            && (this->_ProfileUsageType == rhs._ProfileUsageType)
            && (this->_InUse == rhs._InUse));
   }
} /* namespace bmcore */
